﻿let selectedSDHidden;
let selectedSDDisplay;

function RemoveFromArray(array, element) {
    //remove element form array
    const index = array.indexOf(element);

    if (index !== -1) {
        array.splice(index, 1);
    }
}

function initDateTimepickers() {
    //init all datetimepickers
    var daytimeOpitions = {
        todayHighlight: true,
        autoclose: true,
        daysOfWeekDisabled: "0",
        daysOfWeekHighlighted: "0",
        language: $('#LocaleThread').val(),//navigator.language,
        locale: $('#LocaleThread').val(),//navigator.language,
        useCurrent: false,
        showClear: true,
        showClose: true,
        allowInputToggle: true
    };

    $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
    $('#datetimepickerTo').datetimepicker(daytimeOpitions);
}

function initTimePickers() {
    //init only time pickers
    $('#DayFrom').mask('99:99:99', { placeholder: "00:00:00", selectOnFocus: true });
    $('#DayTo').mask('99:99:99', { placeholder: "23:59:59", selectOnFocus: true });

    $('#DayFrom').val('00:00:00');
    $('#DayTo').val('23:59:59');
}

function initFieldsTab1() {
    //init select2 fields on tab#1 and tab#2
    $('#CallsDirections').select2({ theme: "bootstrap", placeholder: $('#txtDir').val() });
    $('#CallsType').select2({ theme: "bootstrap", placeholder: $('#txtCall').val() });
    $('#RecordType').select2({ theme: "bootstrap", placeholder: $('#txtRec').val() });
    $('#TerminateCodes').select2({ theme: "bootstrap", placeholder: $('#txtTerm').val() });

    $('#CallsCategories').select2({ theme: "bootstrap", placeholder: $('#txtCat').val() });
    $('#DayTypes').select2({ theme: "bootstrap", placeholder: $('#txtDT').val() });
}

function initFieldsTab2() {
    //init select2 when opened tab#2, allways
    setTimeout(function () {
        $('#CallsCategories').select2({ theme: "bootstrap", placeholder: $('#txtCat').val() });
        $('#DayTypes').select2({ theme: "bootstrap", placeholder: $('#txtDT').val() });

        initTimePickers();
    }, 250);
}

function SourceDestinationButtonsVisibleSet() {
    //set visibility of buttons for a selected source and destination
    switch ($('#ViewSource').val()) {
        case '0':
        case '2':
        case '6':
            $('#ViewSourceText').prop('readonly', false);
            $('#btnEditSource').hide();
            break;
        default:
            $('#ViewSourceText').prop('readonly', true);
            $('#btnEditSource').show();
            break;
    }

    switch ($('#ViewDestination').val()) {
        case '0':
        case '2':
        case '6':
            $('#ViewDestinationText').prop('readonly', false);
            $('#btnEditDestination').hide();
            break;
        default:
            $('#ViewDestinationText').prop('readonly', true);
            $('#btnEditDestination').show();
            break;
    }
}

function SourceDestinationOrAndSelectVisibleSet() {
    //show hiden or visible button for select AND, OR for source and destination
    if (!$('#ViewSourceText').val() || !$('#ViewSourceText').val().trim()) {
        $('#SourceDestinationOrAndSelect').hide();
    }
    else {
        $('#SourceDestinationOrAndSelect').show();
    }
}

function AttachEventsForSDTables() {
    selectedSDHidden = [];
    selectedSDDisplay = [];

    //attach events to table with destination and source
    $('#tariscope-SDD tbody').on('click', 'tr', function () {
        let hidden = $(this).find('td[data-name="SDDataHidden"]').text();
        let disaply = $(this).find('td[data-name="SDDataDisplay"]').text();

        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');

            RemoveFromArray(selectedSDHidden, hidden);
            RemoveFromArray(selectedSDDisplay, disaply);
        }
        else {
            if ($(this).data('name') !== 'SDDataNonSelect') {
                selectedSDHidden.push(hidden);
                selectedSDDisplay.push(disaply);
                $(this).addClass('selected');
            }
        }
    });

    let inputs = $('#tariscope-SDD').find('input');

    if (inputs.length) {
        let search = $(inputs[0]);
        search.val('');
        search.unbind();
        search.on('input', () => {
            let str = search.val();

            if (!str || !str.trim()) {
                $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                    $(this).show();
                });
            }
            else {
                $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                    if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                        $(this).show();
                    }
                    else {
                        $(this).hide();
                    }
                });
            }
        });
    }
}

function LoadDNs() {
    //load number and ips
    $('#sourceDestTitle').text($('#txtNumbers').val());

    $('#modalContainer').load('/TariscopeViews/GetNumbersIP/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
        AttachEventsForSDTables();
        ShowSpinner(false);
        $('#containerModal').modal('show');
    });
}

function LoadAbonents() {
    //load abonents
    $('#sourceDestTitle').text($('#txtAbonents').val());

    $('#modalContainer').load('/TariscopeViews/GetAbonents/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
        AttachEventsForSDTables();
        ShowSpinner(false);
        $('#containerModal').modal('show');
    });
}

function LoadDepartments() {
    //load departments
    $('#sourceDestTitle').text($('#txtDepartments').val());

    $('#modalContainer').load('/TariscopeViews/GetDepartments/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
        AttachEventsForSDTables();
        ShowSpinner(false);
        $('#containerModal').modal('show');
    });
}

function LoadGetaway() {
    //load gateways
    $('#sourceDestTitle').text($('#txtRoutes').val());

    $('#modalContainer').load('/TariscopeViews/GetGateways/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
        AttachEventsForSDTables();
        ShowSpinner(false);
        $('#containerModal').modal('show');
    });
}

function LoadDevices() {
    //load devices
    $('#sourceDestTitle').text($('#txtDevices').val());

    $('#modalContainer').load('/TariscopeViews/GetDevices/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
        ShowSpinner(false);
        $('#containerModal').modal('show');
    });
}

$(document).ready(function () {
    let SDmode;

    //when window resized
    $(window).on('resize', initFieldsTab1);

    //show section for enter custom view period
    $('#ViewPeriod').change(function () {
        let selectedValue = $(this).val() * 1;

        switch (selectedValue) {
            case 9:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').show();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 10:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').hide();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 11:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideDown('fast');

                try {
                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
                } catch (e) { }
                break;
            default:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideUp('fast');
                break;
        }

    });

    //manage of visible for source and destination buttons
    $('#ViewSource, #ViewDestination').change(function () {

        if ($(this).attr('id') == 'ViewSource') {
            $('#SourceTextHidden').val('');
            $('#ViewSourceText').val('');

            SourceDestinationOrAndSelectVisibleSet();
        }
        else {
            $('#DestinationTextHidden').val('');
            $('#ViewDestinationText').val('');
        }

        SourceDestinationButtonsVisibleSet();
    });

    //show hide busttom for or and select
    $('#ViewSourceText').on('input', SourceDestinationOrAndSelectVisibleSet);

    //click on edit source
    $('#btnEditSource').on('click', function () {
        ShowSpinner(true);
        SDmode = 1;

        switch ($('#ViewSource').val()) {
            default:
            case '0':
                break;
            case '1':
                LoadDNs();
                break;
            case '3':
                LoadAbonents();
                break;
            case '4':
                LoadDepartments();
                break;
            case '5':
                LoadGetaway();
                break;
        }
    });

    $('#btnEditDestination').on('click', function () {
        ShowSpinner(true);
        SDmode = 2;

        switch ($('#ViewDestination').val()) {
            default:
            case '0':
                break;
            case '1':
                LoadDNs();
                break;
            case '3':
                LoadAbonents();
                break;
            case '4':
                LoadDepartments();
                break;
            case '5':
                LoadGetaway();
                break;
        }
    });

    //select source or destination
    $('#btnSelectSD').on('click', function () {
        if (SDmode === 1) {
            $('#SourceTextHidden').val(selectedSDHidden);
            $('#ViewSourceText').val(selectedSDDisplay);

            SourceDestinationOrAndSelectVisibleSet();
        }
        else if (SDmode === 2) {
            $('#DestinationTextHidden').val(selectedSDHidden);
            $('#ViewDestinationText').val(selectedSDDisplay);
        }
        else {
            $('#ViewDevices').val('');
            $('#ViewDevicesHidden').val('');

            let dh = [];
            let dv = []

            var devc = $("[id^='SelectedDevice_']");
            devc.map(function (e) {
                if ($(devc[e]).prop('checked') === true) {
                    dh.push($(devc[e]).data('device'));
                    dv.push($(devc[e]).data('name'));
                }
            });

            try {
                $('#ViewDevices').val(dv.join());
                $('#ViewDevicesHidden').val(dh.join());
            } catch (e) { }
        }
    });

    //select devices
    $('#btnEditDevices').on('click', function () {
        ShowSpinner(true);
        SDmode = 3;
        LoadDevices();
    });

    //show prebuild sql script
    $('#btnShowSql').on('click', function () {
        $('#warningSQLAlert').hide();
        $('#btnPreSaveSQL').show()
        $('#btnSaveSQL').hide();

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GETSQL/',
            data: $('#ViewFrom').serialize(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent(response.sql), function () {
                        $('#SQLEditor').modal('show');
                    });
                }
            }
        });
    });

    $('#SQLEditor, #containerModal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0) }, 500);
    });

    //show the message when user try save sql
    $('#btnPreSaveSQL').on('click', function () {
        $('#warningSQLAlert').slideDown('fast');
        $('#btnPreSaveSQL').hide();
        $('#btnSaveSQL').show();
    });

    //save custom sal filter
    $('#btnSaveSQL').on('click', function () {
        window.location = '/TariscopeViews/NewCallsFilterSQL/?ViewName=' + encodeURIComponent($('#ViewName').val()) +
            '&RowLimit=' + $('#RowLimit').val() +
            '&SQL=' + encodeURIComponent(window.SQLEditor.getValue());
    });

    //open fileds to edit
    $('#btnFieldsEdit').on('click', () => {
        if ($('#FieldsContainer').is(':empty')) {
            $('#FieldsContainer').load('/TariscopeViews/GetFieldsForEmpty?Type=0', () => {
                //move buttons (top down)
                $('.tcxField').mouseover(function () {
                    $(this).append($('#btnsTopDown'));
                });

                //mode top
                $('#btnMoveTcxFieldTop').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let PrevElement = $(this).parent().parent().prev();

                    if (PrevElement.length > 0) {
                        let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let PrevInput = $(InputToMove).prev();
                        let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

                        $(CurrentElement).insertBefore($(PrevElement));

                        if (ExpectPrevNumber === RealPrevNumber)
                            $(InputToMove).insertBefore(PrevInput);
                    }
                });

                //mode down
                $('#btnMoveTcxFieldDown').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let NextElement = $(this).parent().parent().next();

                    if (NextElement.length > 0) {
                        let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let NextInput = $(InputToMove).next();
                        let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

                        $(CurrentElement).insertAfter($(NextElement));

                        if (ExpectNextNumber === RealNextNumber)
                            $(InputToMove).insertAfter(NextInput);
                    }
                });

                $('#FieldsEditor').modal('show');
            });
        }
        else {
            $('#FieldsEditor').modal('show');
        }
    });

    //save fields
    $('#btnSaveFields').on('click', () => {
        var f = $("[id^='field_']");
        var v = [];

        f.map(function (e) {
            if ($(f[e]).prop('checked'))
                v.push($(f[e]).data('field'));
        });

        $('#Fields').val(v.join());
    });

    $('#btnSaveSQL').hide();
    SourceDestinationButtonsVisibleSet();
    SourceDestinationOrAndSelectVisibleSet();
    initFieldsTab1();
    initDateTimepickers();
});