﻿let buttonToValidate = null;
let reqVars = [];

function SetButtonToValidate(name) {
    buttonToValidate = $('#' + name);
    ValidateReportsVars();
}

function GetVariablesJsonString() {
    var vars = {};
    var els = $('input[name="ReportVariable"]');
    for (var i = 0; i < els.length; i++) {
        let id = $(els[i]).prop('id').replace('var_', '');
        vars[id] = GetVariableVal(id);
    }

    return JSON.stringify(vars);
}

function SetVariablesFromJsonString(jsonVars) {
    var vars = {};

    try {
        vars = JSON.parse(jsonVars);
    } catch (e) { }

    for (key in vars) {
        //console.log(key, " :", vars[key]);
        SetVariableVal(key, vars[key]);
    }
}

function ValidateReportsVars() {
    if (reqVars != null && buttonToValidate != null) {
        for (var key in reqVars) {
            if (/^\s*$/.test(reqVars[key])) {
                buttonToValidate.attr('disabled', true);
                return;
            }

            buttonToValidate.attr('disabled', false);
        }
    }
}

function GetVariableVal(name) {
    let el = $('#var_' + name);
    let type = el.data('type');

    if (type == "3") {
        return el.prop('checked');
    }
    else if (type == "2") {
        if ($('#varc_' + name).is(":hidden")) {
            const pickerdate = $('#dt_var_' + name).data("DateTimePicker").getDate();
            var pday = pickerdate.date().toString();
            if (pday.length == 1) { pday = '0' + pday;}
            var pmonth = (pickerdate.month() + 1).toString();
            if (pmonth.length == 1) { pmonth = '0' + pmonth;}
            var pyear = pickerdate.year().toString();
            var phours = pickerdate.hours().toString();
            if (pickerdate.hours() < 10)
            { phours = '0' + phours; }
            var pminutes = pickerdate.minutes().toString();
            if (pickerdate.minutes() < 10)
            { pminutes = '0' + pminutes; }
            var pseconds = pickerdate.seconds().toString();
            if (pickerdate.seconds() < 10)
            { pseconds = '0' + pseconds; }
            var rdate = pyear + '-' + pmonth + '-' + pday.toString() + 'T' + phours + ':' + pminutes + ':' + pseconds + '.0000000';
            //return $('#dt_var_' + name).data("DateTimePicker").getDate().toISOString().replace('000Z', '0000000');
            return rdate;
        }
        else {
            return $('#varc_' + name).val();
        }
    }
    else {
        if ($('#varc_' + name).is(":hidden")) {
            return el.val();
        }
        else {
            return $('#varc_' + name).val();
        }
    }
}

function SetVariableVal(name, value) {
    let el = $('#var_' + name);
    let type = el.data('type');
    if (type == 3) {
        el.prop('checked', value);
    }
    else if (type == 2) {
            if ((value + '').startsWith('=')) {
                $('#dt_var_' + name).parent().parent().find('.btnSelectReportConstant').hide();
                $('#dt_var_' + name).parent().parent().find('.btnClearReportConstant').show();
                $('#dt_var_' + name).hide();
                $('#varc_' + name).show();
                $('#varc_' + name).val(value);
                //console.log("Type = 2 & value + , ", value);
            }
         else {
                $('#dt_var_' + name).data("DateTimePicker").setDate(new Date(value.replace('.0000000', '')));
                let offsetMinutes = new Date().getTimezoneOffset();
                //console.log("Offset: ", offsetMinutes);
                //console.log("Type2: ", value);
        }
    }
    else {
        if ((value + '').startsWith('=')) {
            $('#var_' + name).parent().parent().find('.btnSelectReportConstant').hide();
            $('#var_' + name).parent().parent().find('.btnClearReportConstant').show();
            $('#var_' + name).hide();
            $('#varc_' + name).show();
            $('#varc_' + name).val(value);
            //console.log("Additional Option 1");
        }
        else if (type != 2 || type != 3) {
            $('#var_' + name).val(value);
            //console.log("Additional Option 2", type.toString());
        }
    }
}

$(document).ready(() => {
    var daytimeOpitions = {
        todayHighlight: true,
        autoclose: true,
        daysOfWeekDisabled: "0",
        daysOfWeekHighlighted: "0",
        language: $('#LocaleThread').val(),//navigator.language,
        locale: $('#LocaleThread').val(),//navigator.language,
        useCurrent: false,
        showClear: true,
        showClose: true,
        allowInputToggle: true
    };

    function InitVariables() {
        buttonToValidate = null;
        reqVars = [];

        var els = $('[name="ReportVariable"]');
        for (var i = 0; i < els.length; i++) {
            let name = $(els[i]).data('name');
            let type = $(els[i]).data('type');
            let isreq = $(els[i]).data('req') == "1";

            if (type == "2") {
                $('#dt_var_' + name).datetimepicker(daytimeOpitions);
                $('#dt_var_' + name).data("DateTimePicker").setDate(new Date($('#var_' + name).val()));
            }

            if (isreq) {
                reqVars['var_' + name] = GetVariableVal(name);

                if (type == '2') {
                    $('#dt_var_' + name).on('dp.change', function (e) {
                        reqVars['var_' + name] = GetVariableVal(name);
                        ValidateReportsVars();
                    });
                }
                else {
                    $('#' + 'var_' + name).on('input', function () {
                        reqVars['var_' + name] = GetVariableVal(name);
                        ValidateReportsVars();
                    });
                }
            }
        }

        ValidateReportsVars();
    }

    //show constants to select
    $('.btnSelectReportConstant').on('click', function () {
        let name = $(this).data('var');
        let el = $('#var_' + name);
        let cons = $('#varc_' + name);
        let type = el.data('type');

        if (type == "2") {
            $('#dt_var_' + name).hide();
        }
        else {
            el.hide();
        }

        $(this).hide();
        $(this).parent().find('.btnClearReportConstant').show();

        cons.show();

        let key = `var_${name}`;
        if (key in reqVars)
            reqVars[key] = cons.val();

        ValidateReportsVars();
    });

    //hide constants
    $('.btnClearReportConstant').on('click', function () {
        let name = $(this).data('var');
        let el = $('#var_' + name);
        let cons = $('#varc_' + name);
        let type = el.data('type');

        cons.hide();

        $(this).hide();
        $(this).parent().find('.btnSelectReportConstant').show();

        if (type == "2") {
            $('#dt_var_' + name).show();
        }
        else {
            el.show();
        }

        let key = `var_${name}`;
        if (key in reqVars)
            reqVars[key] = GetVariableVal(name);

        ValidateReportsVars();
    });

    //update var from constant
    $('.variable-report-constant').change(function () {
        let key = `var_${$(this).data('name')}`;
        if (key in reqVars)
            reqVars[key] = $(this).val();

        ValidateReportsVars();
    });

    InitVariables();
});