﻿function nextTab(elem) {
    //go to next wizard page
    $(elem).next().find('a[data-toggle="tab"]').click();
}

function prevTab(elem) {
    //go to prev wizard page
    $(elem).prev().find('a[data-toggle="tab"]').click();
}

function InitTable(data) {
    //create head row
    var trHead = document.createElement('tr');
    for (var i = 0; i < data[0].length; i++) {
        //create cell
        var th = document.createElement('th');
        th.innerText = data[0][i];
        //add cell to row
        trHead.appendChild(th);
    }
    $('#tableWithData tr:last').after(trHead);


    for (var i = 1; i < data.length; i++) {
        //create row
        var tr = document.createElement('tr');
        for (var j = 0; j < data[i].length; j++) {
            //create cell
            var td = document.createElement('td');
            td.innerText = data[i][j];
            //add cell to row
            tr.appendChild(td);
        }
        //add row to table
        $('#tableWithData tr:last').after(tr);
    }

}

function AddFields(data) {
    //add empty field
    $('#selectCode').append('<option value="' + -1 + '"></option>');
    $('#selectDescription').append('<option value="' + -1 + '"></option>');
    $('#selectCategory').append('<option value="' + -1 + '"></option>');
    $('#selectRate').append('<option value="' + -1 + '"></option>');
    $('#selectRateName').append('<option value="' + -1 + '"></option>');
    $('#selectGroup').append('<option value="' + -1 + '"></option>');
    $('#selectRecDate').append('<option value="' + -1 + '"></option>');
    $('#selectLatitude').append('<option value="' + -1 + '"></option>');
    $('#selectLongitude').append('<option value="' + -1 + '"></option>');
    $('#selectEnable').append('<option value="' + -1 + '"></option>');
    $('#selectDisable').append('<option value="' + -1 + '"></option>');

    //add source fields
    for (var i = 0; i < data.length; i++) {
        $('#selectCode').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectDescription').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectCategory').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectRate').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectRateName').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectGroup').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectRecDate').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectLatitude').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectLongitude').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectEnable').append('<option value="' + i + '">' + data[i] + '</option>');
        $('#selectDisable').append('<option value="' + i + '">' + data[i] + '</option>');
    }
}

function SelectedMatch(data) {
    //select matched fields
    $('#selectCode').val(data[0]);
    $('#selectDescription').val(data[1]);
    $('#selectCategory').val(data[2]);
    $('#selectRate').val(data[3]);
    $('#selectRateName').val(data[4]);
    $('#selectGroup').val(data[5]);
    $('#selectRecDate').val(data[6]);
    $('#selectLatitude').val(data[7]);
    $('#selectLongitude').val(data[8]);
    $('#selectEnable').val(data[9]);
    $('#selectDisable').val(data[10]);
}

function Start() {
    //start export
    $.ajax({
        type: "POST",
        async: true,
        url: '/DestinationCodesImport/Start/',
        traditional: true
    });
}

function GetStatus() {
    $.ajax({
        type: "POST",
        async: true,
        url: '/DestinationCodesImport/GetStatus/',
        traditional: true,
        success: function (response) {
            if (response != null && response.success == true) {
                //not yet
                var percent = (response.x * 100) / response.y;
                $('#procc').css('width', percent + '%');
                $('#procc').html(response.x + ' / ' + response.y);

                if (!response.c) {
                    GetStatus();
                }
                //completed
                else {
                    $('#process').attr('hidden', true);
                    $('#compl').attr('hidden', false);

                    $('#procc').css('width', '100%');
                    $('#procc').html(response.msg);

                    $('#added').html(response.add);
                    $('#rtadded').html(response.rtu);

                    $('#proccContainer').slideUp('fast');
                    $('#ImportStatus').slideDown('fast');
                    $('#ButtonsEndCase').slideDown('fast');
                }
            }
            else {
                $('#process').attr('hidden', true);
                $('#compl').attr('hidden', true);
                $('#errorl').attr('hidden', false);

                $('#errorMsg').html(response.msg);

                $('#proccContainer').slideUp('fast');
                $('#ImportStatusError').slideDown('fast');
                $('#ButtonsEndCase').slideDown('fast');
            }
        }
    });
}

function MakeDisable(num) {
    //disable nex steps if prev was proccesed again
    for (var i = num; i < 8; i++) {
        var elem = $('a[aria-controls="step' + (i + 2) + '"]');
        elem.parent().addClass('disabled');
    }
}

function ClearTableAndSelect() {
    //remove prev added data to table and selectes
    $("#tableWithData tr").remove();
    $("#tableWithData tbody").append('<tr></tr>');

    $('#selectCode option').remove();
    $('#selectDescription option').remove();
    $('#selectCategory option').remove();
    $('#selectRate option').remove();
    $('#selectRateName option').remove();
    $('#selectGroup option').remove();
    $('#selectRecDate option').remove();
    $('#selectLatitude option').remove();
    $('#selectLongitude option').remove();
    $('#selectEnable option').remove();
    $('#selectDisable option').remove();
}

$(document).ready(function () {
    //back to providers and rates
    $('#ABackToProvider').on('click', LoadPreview);
    $('#ABackToDest, #CancelImport').on('click', function () { location.reload(); });

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //chnage file format
    $('#SelectFileFormat').change(function () {
        $('#FileInput').attr('accept', '.' + $('#SelectFileFormat option:selected').val());
    });

    //get tables names
    $('#FileProcessButton').on('click', function () {
        var data = new FormData();
        var file = ($("#FileInput"))[0].files[0];

        if (file != null) {
            ShowSpinner(true);
            $('#emptyFile').slideUp('fast');
            data.append($('#SelectFileFormat option:selected').val(), file);

            $.ajax({
                type: "POST",
                async: true,
                url: '/DestinationCodesImport/LoadFile/?type=' + $('#SelectFileFormat option:selected').val(),
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        //clear select with tables and load new
                        $('#SelectWitTables').empty();
                        response.tables.forEach(function (e) {
                            $('#SelectWitTables').append('<option value="' + e + '">' + e + '</option>');
                        });

                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                        MakeDisable(2);
                    }
                    else {
                        $('#FileProcessButton').attr('disabled', true);
                    }
                    ShowSpinner(false);
                }
            });
        }
        else {
            $('#emptyFile').slideDown('fast');
        }
    });

    //get predata and build table
    $('#FilePreloadButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodesImport/GetPreData/?table=' + encodeURIComponent($('#SelectWitTables option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    //build table with pre data
                    ClearTableAndSelect();
                    InitTable(response.tb);

                    //add fields to selectes
                    AddFields(response.tb[0]);

                    //selected matched
                    SelectedMatch(response.sl);

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(3);
                }
                else {
                    $('#FilePreloadButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //send selected matches
    $('#FileMatchButton').on('click', function () {
        ShowSpinner(true);

        var mathces = $('#selectCode').val() + ',' +
            $('#selectDescription').val() + ',' +
            $('#selectCategory').val() + ',' +
            $('#selectRate').val() + ',' +
            $('#selectRateName').val() + ',' +
            $('#selectGroup').val() + ',' +
            $('#selectRecDate').val() + ',' +
            $('#selectLatitude').val() + ',' +
            $('#selectLongitude').val() + ',' +
            $('#selectEnable').val() + ',' +
            $('#selectDisable').val();

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodesImport/SetMatch/?mathces=' + mathces,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(4);
                }
                else {
                    $('#FileMatchButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //save primary key
    $('#FileSaveKeyButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodesImport/SaveKey/' + $('input[name=pKey]:checked').val(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(5);
                }
                else {
                    $('#FileSaveKeyButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //save primary key
    $('#SavePlaneButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodesImport/SavePlane/' + $('#RatePlane option:selected').val(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(-1);

                    Start();
                    GetStatus();
                }
                else {
                    $('#SavePlaneButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //cloase wizard
    $('#CloseWizard').on('click', function () {
        location.reload();
    });
});