﻿$(document).ready(() => {
    function ButtonDeleteEvent() {
        $('.btnDelete').unbind();
        $('.btnDelete').on('click', function () {
            $(this).parent().parent().remove();
            RecalculateContactsStr();
        });
    }

    function RecalculateContactsStr() {
        var contacts = [];
        var els = $('.contact-f');

        for (var i = 0; i < els.length; i++) {
            contacts.push($(els[i]).text());
        }

        $('#ContactsStr').val(contacts.join(","));
    }

    //show modal to add a new contact
    $('#btnAdd').on('click', () => {

        $('#NewContact').val('');
        $('#EmptyContact').hide();
        $('#AddContact').prop('disabled', true);

        $('#AddContactModal').modal('show');
    });

    //show error when contact field is emprt
    $('#NewContact').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#EmptyContact').slideDown('fast');
            $('#AddContact').prop('disabled', true);
        }
        else {
            $('#EmptyContact').slideUp('fast');
            $('#AddContact').prop('disabled', false);
        }
    });

    //confirm add contact
    $('#AddContact').on('click', () => {
        $('#ContactsList').append(`<tr>
                                            <td>
                                                <button type="button" class="btn btn-box-tool btnDelete"><i class="fa fa-trash fa-lg"></i></button>
                                                <span class="contact-f">${$('#NewContact').val()}</span>
                                            </td>
                                        </tr>`);

        $('#AddContactModal').modal('hide');
        ButtonDeleteEvent();
        RecalculateContactsStr();
    });

    ButtonDeleteEvent();
});