﻿$(document).ready(() => {
    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerID').datetimepicker(options);
        $('#datetimepickerDT').datetimepicker(options);
    }

    //expand panel for edit my sql connection
    $('#editMySQLConnection').on('click', () => {
        $('#editMySQLConnection').addClass('disDiv');

        $.ajax({
            type: "POST",
            url: '/Observers/ParseMySQLConnectionString/?CN=' + encodeURIComponent($('#ConnectionString').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#MySQLServer').val(response.Server);
                    $('#MySQLDB').val(response.Database);
                    $('#MySQLUser').val(response.UserID);
                    $('#MySQLPassword').val(response.Password);

                    $('#editMySQLConnection').fadeTo('fast', 0, () => { $('#editMySQLConnection').removeClass('disDiv'); });
                    $('#MySqlConnectionSection').slideDown('fast');
                }
            }
        });
    });

    //cancel edit my sql connection
    $('#cancelEditMySql').on('click', () => {
        $('#MySqlConnectionSection').slideUp('fast');
        $('#editMySQLConnection').fadeTo('fast', 1);
    });

    //save my sql connection
    $('#saveEditMySql').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Observers/BuildMySQLConnectionString/?Server=' + encodeURIComponent($('#MySQLServer').val())
                + '&Database=' + encodeURIComponent($('#MySQLDB').val())
                + '&UserID=' + encodeURIComponent($('#MySQLUser').val())
                + '&Password=' + encodeURIComponent($('#MySQLPassword').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#ConnectionString').val(response.cn);

                    $('#MySqlConnectionSection').slideUp('fast');
                    $('#editMySQLConnection').fadeTo('fast', 1);
                }
            }
        });
    });

    initdatetime();
});