﻿$(document).ready(() => {
    //close details
    $('#CloseDetailsBtn').on('click', function () {
        $('.mainrow').removeClass('selected');
        $('.detailrow').hide();
        $('.detailrow').html('');
    });

    //take order
    $('#TakeOrderBtn').on('click', function () {
        let order = $(this).data('id');

        $.ajax({
            type: "POST",
            url: '/EmployeeArea/Take/' + order,
            traditional: true,
            success: function (response) {
                if (response.success === true) {
                    LoadDetails(order);
                    $('#OrderSuccessModalMessage').text(response.message);
                    $('#OrderSuccessModal').modal('show');
                }
                else {
                    $('#OrderFailModalMessage').text(response.message);
                    $('#OrderFailModal').modal('show');
                }
            }
        });
    });

    //complete order
    $('#CompleteOrder').on('click', function () {
        let order = $(this).data('id');

        $('#CompleteWorkOrderInput').val('');

        $('#CompleteWorkOrderBtn').unbind();
        $('#CompleteWorkOrderBtn').on('click', () => {
            $('#CompleteWorkOrderModal').modal('hide');
            $.ajax({
                type: "POST",
                url: `/EmployeeArea/Complete/${order}/?Commentary=${encodeURIComponent($('#CompleteWorkOrderInput').val())}`,
                traditional: true,
                success: function (response) {
                    if (response.success === true) {
                        LoadDetails(order);
                        $('#OrderSuccessModalMessage').text(response.message);
                        $('#OrderSuccessModal').modal('show');
                    }
                    else {
                        $('#OrderFailModalMessage').text(response.message);
                        $('#OrderFailModal').modal('show');
                    }
                }
            });
        });

        $('#CompleteWorkOrderModal').modal('show');
    });
});