﻿$(document).ready(() => {
    function SetAuthPrefixInput() {
        if ($('#AuthCodePatternCheckBox').prop('checked')) {
            $('#AuthCodePattern').prop('disabled', false);
        }
        else {
            $('#AuthCodePattern').val('');
            $('#AuthCodePattern').prop('disabled', true);
        }
    }

    function GetInfoAbout3CXService() {
        if ($('#MonitorActiveCalls').prop('checked') === true) { $('#realtimeSettingsSection').show(); }
        else { $('#realtimeSettingsSection').hide('fast'); }

        if ($('#DropBalanceLessThen').prop('checked') === true) { $('#Balance').attr('readonly', false); }
        else { $('#Balance').attr('readonly', true); }

        if ($('#DropCostMoreThen').prop('checked') === true) { $('#Cost').attr('readonly', false); }
        else { $('#Cost').attr('readonly', true); }

        if ($('#DropDurationMoreThen').prop('checked') === true) { $('#Duration').attr('readonly', false); }
        else { $('#Duration').attr('readonly', true); }

        if ($('#DropNoAccessCode').prop('checked') === true) { $('#AccessCodes').attr('readonly', false); }
        else { $('#AccessCodes').attr('readonly', true); }

        if ($('#DropDirections').prop('checked') === true) { $('#Directions').attr('readonly', false); }
        else { $('#Directions').attr('readonly', true); }

        if ($('#CorrectTransfresDirations').prop('checked') === true) { $('#RingTimeDelta').attr('readonly', false); }
        else { $('#RingTimeDelta').attr('readonly', true); }

        if ($('#ExportQueryInfo').prop('checked') === true) { $('#ExportQueryInfoPeriod').attr('readonly', false); }
        else { $('#ExportQueryInfoPeriod').attr('readonly', true); }
    }

    function SendResetConnection() {
        $.ajax({
            type: "POST",
            url: '/Devices/ResetConnection/' + $('#parserID').val(),
            traditional: true
        });
    }

    function CheckFileds() {
        let els = $('input[id^="Fields["]');

        let target = null;

        for (let i = 0; i < els.length; i++) {
            let e = $('input[enumnumber="' + $(els[i]).val() + '"]');
            e.prop('checked', true);

            if (target == null)
                $('#tcxSwitchfieldsContainer').prepend(e.parent());
            else
                e.parent().insertAfter(target);

            target = e.parent();
        }
    }

    //update prefix input
    $('#AuthCodePatternCheckBox').change(SetAuthPrefixInput);

    //block panel for realtime settings
    $('#MonitorActiveCalls').change(function () {
        if ($(this).prop('checked'))
            $('#realtimeSettingsSection').slideDown('fast');
        else
            $('#realtimeSettingsSection').slideUp('fast');
    });

    //save button
    $('#btnSuccess3CX').on('click', function () {
        
        SendConfiguration(this);

        setTimeout(SendResetConnection, 1000);
    });

    //set fields
    $('input[id^="tcxfield_"]').change(function () {
        let checked = $(this).prop('checked');
        let number = $(this).attr('enumnumber') * 1;

        if (checked)
            $('#tcxfieldsContainer').append('<input id="Fields[' + number + ']" type="number" value="' + number + '" name="Fields[' + number + ']"/>');
        else
            $('input[name="Fields[' + number + ']"]').remove();
    });

    //move buttons (top down)
    $('.tcxField').mouseover(function () {
        $(this).append($('#btnsTopDown'));
    });

    //mode top
    $('#btnMoveTcxFieldTop').on('click', function () {
        let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
        let CurrentElement = $(this).parent().parent();
        let PrevElement = $(this).parent().parent().prev();

        if (PrevElement.length > 0) {
            let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
            let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
            let PrevInput = $(InputToMove).prev();
            let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

            $(CurrentElement).insertBefore($(PrevElement));

            if (ExpectPrevNumber === RealPrevNumber)
                $(InputToMove).insertBefore(PrevInput);
        }
    });

    //mode down
    $('#btnMoveTcxFieldDown').on('click', function () {
        let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
        let CurrentElement = $(this).parent().parent();
        let NextElement = $(this).parent().parent().next();

        if (NextElement.length > 0) {
            let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
            let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
            let NextInput = $(InputToMove).next();
            let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

            $(CurrentElement).insertAfter($(NextElement));

            if (ExpectNextNumber === RealNextNumber)
                $(InputToMove).insertAfter(NextInput);
        }
    });

    //update fields when change ckeckbox status
    $('.settingsCheckbox').change(GetInfoAbout3CXService);

    //start import abonents from 3cx
    $('#btnExport3CX').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/Devices/3CX/Import/' + $('#parserID').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    $('#importedAbonentsMessage').html(response.msg);
                    $('#importedAbonentsModal').modal('show');
                }
            }
        });
    });

    //start test connection
    $('#btnTestConnection').on('click', () => {
        $('#btnTestConnection').addClass('disDiv');
        $.ajax({
            type: "POST",
            url: '/Devices/3CX/Test3CXConnection/?BaseURL=' + encodeURIComponent($('#FQDN').val()) + '&Port=' + $('#Port').val() + '&Login=' + encodeURIComponent($('#Username').val()) + '&Password=' + encodeURIComponent($('#Password').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#btnTestConnection').prop('disabled', false);
                    if (response.data.Success === true) {
                        $('#testConnectionsuccess').slideDown('fast');
                        setTimeout(() => {
                            $('#testConnectionsuccess').slideUp('fast');
                            $('#btnTestConnection').removeClass('disDiv');
                        }, 3000);
                    }
                    else {
                        $('#testConnectionerror').slideDown('fast');
                        $('#tcxConnectionError').text(response.data.Message);
                        setTimeout(() => {
                            $('#testConnectionerror').slideUp('fast');
                            $('#btnTestConnection').removeClass('disDiv');
                        }, 3000);
                    }
                }
            }
        });

    });

    CheckFileds();
    GetInfoAbout3CXService();
    SetAuthPrefixInput();
});