﻿$(document).ready(function () {
    var selectedHistory = null;

    function ShowSpinnerInfor(show) {
        /*
         * function for showing spinner message when load edit preview
         * sometimes it is to long
         */
        if (show) {
            $("#loadMeInformation").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#loadMeInformation").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
        }
    };

    function UpdateButtonsUI() {
        //enable/disable rename button
        if (selectedHistory == null) {
            $("#btnDescription").attr("disabled", true);
        }
        else {
            $("#btnDescription").attr("disabled", false);
        }
    };

    function AttachEventsToTable() {
        //attach events for select history item
        $('#tariscope-databasebackups tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedHistory = null;
            }
            else {
                selectedHistory = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-databasebackups tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsUI();
        });
    };

    function LoadHistory() {
        //load table with backups history
        selectedHistory = null;
        UpdateButtonsUI();
        $('#historyContainer').load('/Database/GetBackupHistory', AttachEventsToTable);
    };

    function ShowAlert() {
        //show true alert (new backup or old or never created)
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetAlertInfo/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    if (response.alertlevel == 'low') {
                        $('#LowAlertBKText').html(response.alertmsg);
                        $('#LowAlertBK').slideDown('fast');
                    }
                    else {
                        $('#HightAlertBKText').html(response.alertmsg);
                        $('#HightAlertBK').slideDown('fast');
                    }
                }
            }
        });
    };

    function GetBackupStatus() {
        //get information about status of backup
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetBackupStatus/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    if (response.IsCompleted == false)
                        setTimeout(GetBackupStatus, 1000);
                    else {
                        ShowSpinnerInfor(false);

                        if (response.IsSuccessfullyCompleted == true) {
                            LoadHistory();
                            $('#pSuccess').html(response.BackupMessage);
                            $('#Successdmodal').modal('show');
                        }
                        else {
                            $('#pError').html(response.BackupMessage);
                            $('#Errordmodal').modal('show');
                        }
                    }
                }
            }
        });
    }

    function CreateBackup(isfull) {
        //start creating backup
        ShowSpinnerInfor(true);
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/CreateBackup/?isfull=' + isfull,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    GetBackupStatus();
                }
            }
        });
    }

    //attach event for crate full and diff backups
    $('#btnBKFull').on('click', function () { CreateBackup(true) });
    $('#btnBKDiff').on('click', function () { CreateBackup(false) });

    //show dialog for save new location
    $('#MakeNewSavingPath').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetSaveLocation/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#savingLocation').val(response.path);
                    $('#emptyPath').slideUp();
                    $('#newPathmodal').modal('show');
                }
            }
        });
    });

    //confirm saving new location
    $('#btnSaveLocation').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/SaveNewLocation/?path=' + encodeURIComponent($('#savingLocation').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#tSavingPath').text(response.path);
                    $('#newPathmodal').modal('hide');
                }
            }
        });
    });

    //show message when location is empty
    $('#savingLocation').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyPath').slideDown('fast');
            $('#btnSaveLocation').prop('disabled', true);
        }
        else {
            $('#emptyPath').slideUp('fast');
            $('#btnSaveLocation').prop('disabled', false);
        }
    });

    //show modal for clean hidstory
    $('#btnClear').on('click', function () {
        $('#confirmCleanHistory').modal('show');
    });

    //clear history of backups
    $('#CleanHistoryConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/ClearHistoryLine/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#confirmCleanHistory').modal('hide');
                    LoadHistory();
                }
            }
        });
    })

    //refresh history table
    $('#btnRefresh').on('click', LoadHistory);

    //show modal for chnage desciption
    $('#btnDescription').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetDescription/' + selectedHistory,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#historyDesciption').val(response.desc);
                    $('#emptyDesc').slideUp();
                    $('#editDescriptionmodal').modal('show');
                }
            }
        });
    });

    //show message when description is empty
    $('#historyDesciption').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyDesc').slideDown('fast');
            $('#btnSaveDescription').prop('disabled', true);
        }
        else {
            $('#emptyDesc').slideUp('fast');
            $('#btnSaveDescription').prop('disabled', false);
        }
    });

    //save new desciption
    $('#btnSaveDescription').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/SaveDescription/?id=' + selectedHistory + '&newDesc=' + encodeURIComponent($('#historyDesciption').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    LoadHistory();
                    $('#editDescriptionmodal').modal('hide');
                }
            }
        });
    });

    LoadHistory();
    ShowAlert();
});