﻿$(document).ready(function () {
    var reqID = null;
    var focused = true;

    let state = -1;

    function LoadDataOfSvc() {
        if (focused) {
            $.ajax({
                type: "POST",
                url: '/AI/Prediction/GetSvcInfo/',
                async: true,
                success: function (response) {
                    let runnig = response.success;

                    if ((state == 1 && !runnig) || (state == 2 && runnig)) {
                        $('#btnRun').attr('disabled', true);
                        $('#btnStop').attr('disabled', true);
                    }
                    else {
                        if (runnig) {
                            $('#btnRun').attr('disabled', true);
                            $('#btnStop').attr('disabled', false);
                        }
                        else {
                            $('#btnRun').attr('disabled', false);
                            $('#btnStop').attr('disabled', true);
                        }

                        state = -1;
                        $('#WaitSection').hide();
                    }

                    reqID = setTimeout(LoadDataOfSvc, 1500);
                }
            });
        }
    };

    function AttachEventsForSettings() {
        //run service
        $('#btnRun').on('click', function () {
            state = 1;
            $('#btnRun').attr('disabled', true);
            $('#WaitSection').show();
            $.ajax({
                type: "POST",
                url: '/AI/Prediction/Run/',
                success: function (response) { }
            });
        });

        //stop service
        $('#btnStop').on('click', function () {
            state = 2;
            $('#btnStop').attr('disabled', true);
            $('#WaitSection').show();
            $.ajax({
                type: "POST",
                url: '/AI/Prediction/Stop/',
                success: function (response) { }
            });
        });

        //open list of tasks
        $('#btnSettings').on('click', () => {
            window.open('/AI/Prediction/Settings', '_parent');
        });

        //open log
        $('#btnLog').on('click', () => {
            window.open('/Logger/Prediction', '_parent');
        });

        //open report
        $('#btnLastReport').on('click', () => {
            window.open('/AI/Prediction/Report', '_parent');
        });

        //got focus
        document.addEventListener('visibilitychange', function (ev) {
            let old = focused;
            focused = document.visibilityState == 'visible';

            if (!old && focused) {
                LoadDataOfSvc();
            }
            else {
                clearTimeout(reqID);
            }
        });
    };

    AttachEventsForSettings();
    LoadDataOfSvc();
});