﻿using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using System.Text;

public class ConnectionErrorScript : IScript
{
    private IScriptHost Host;

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }

    public void Main(object Parameters)
    {
        StringBuilder MessageText = new StringBuilder();
        MessageText.AppendLine("Tariscope observer reports connection error. ");
        MessageText.AppendLine(string.Format("Profile name: {0}", (Parameters as MediationActionParameters)?.ProfileName));
        MessageText.AppendLine(string.Format("Error text: {0}", (Parameters as MediationActionParameters)?.ResultDescription));

        this.Host.SendMail("", "Connection error", MessageText.ToString());
    }
}
