﻿using System;
using System.Linq;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using Microsoft.Data.SqlClient;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPi.Tariscope.DAL;

public class DeniedCallScanner : IScript
{
    private IScriptHost Host;
    private bool NeedFinish = false;

    // 
    // ******************************************************************************************************************
    // 
    private int MAX_CALL_DURATION_S = 150;

    private int CALLTYPE_INTERNATIONAL = 5;
    // 
    // ******************************************************************************************************************
    // 


    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        NeedFinish = false;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            var c = (NewCallActionParameters)Parameters;
            using (SqlConnection cn = new SqlConnection(this.Host.DatabaseConnectionString))
            {
                cn.Open();
                CallItems CallItems = CallItems.Instance(cn);
                int FromAbonentId = 0;
                DateTime CallDateTime = DateTime.Now;
                SqlCommand cmd = CallItems.GetCommand("SELECT ID, CallType, FromAbonentId, CallDateTime FROM viCalls WHERE ID=@callid");
                cmd.Parameters.AddWithValue("@callid", c.Id);
                using (SqlDataReader rs = cmd.ExecuteReader())
                {
                    if (rs.Read())
                    {
                        if (rs.GetInt16(1) < 3 || rs.GetInt16(1) > 6)
                            return;
                        FromAbonentId = rs.GetInt32(2);
                        CallDateTime = rs.GetDateTime(3);
                    }
                }
                AbonentCredits creditsContext = AbonentCredits.Instance(cn);
                var credits = creditsContext.Load(FromAbonentId);
                if (credits.Any(x => x.RestrictStatus == RestrictStatus.Restricted))
                    this.Host.SendMail("", "PBX Restriction violation", "Suspicious call detected. ID=" + c.Id + " CallDateTime=" + CallDateTime + " AbonentId=" + FromAbonentId);
            }
        }
        catch (Exception ex)
        {
            this.Host.AddEvent("Error running script:" + ex.ToString());
        }
    }
}
