﻿$(document).ready(function () {

    var rateID = null

    function atachEventToRatesTable() {
        $('#tariscope-rates-edit tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                rateID = null;
            }
            else {
                rateID = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-rates-edit tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsUI();
        });
    };

    function initCurrencyField() {
        //init to courrency field
        $.ajax({
            type: "POST",
            url: '/CurrencyRates/GetMainCurrencyRateName/',
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#addToCurrencyRateName').val(response.name);
                }
            },
            failure: function (response) {
                alert(response.responseText);
            },
            error: function (response) {
                alert(response.responseText);
            }
        });
    };

    function initDateTimePicker() {

        var dateNow = new Date();
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: navigator.language,
            locale: navigator.language,
            useCurrent: false
        };

        $('#datetimepicker').datetimepicker(options);
    };

    function UpdateInfo() {
        $('#currencyData').html('1 ' + $('#addCurrencyRateName').val() + " = " + $('#addCurrencyRateValue').val() + $('#addToCurrencyRateName').val());
    };

    function AddRate() {
        $('#editModalRateHeader').attr("hidden", true);
        $('#addModalRateHeader').attr("hidden", false);
        $('#datetimepickerValue').val(new Date().toLocaleString());
        $('#editRateModal').modal({ show: 'true' });
    };

    function EditRate() {
        $.ajax({
            type: "POST",
            url: '/CurrencyRates/GetRate/?id=' + rateID + "&CurrencyID=" + $('#CurrencyID').val(),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                if (response != null && response.success == true) {

                    $('#editModalRateHeader').attr("hidden", false);
                    $('#addModalRateHeader').attr("hidden", true);

                    $('#datetimepickerValue').val(response.recdate)
                    $('#addCurrencyRateID').val(rateID);
                    $('#addCurrencyRateValue').val(response.rate);

                    $('#editRateModal').modal({ show: 'true' });
                }
            }
        });
    };

    function EditCurrency(id) {
        $('#editModalRateHeader').attr("hidden", false);
        $('#addModalRateHeader').attr("hidden", true);

        $('#editRateModal').load("/CurrencyRates/AddRate/", function () { $('#editRateModal').modal({ show: 'true' }); });
    };

    function UpdateButtonsUI() {
        if (rateID == null) {
            $("#btnEdit-Edit").attr("disabled", true);
            $("#btnDelete-Edit").attr("disabled", true);
        }
        else {
            $("#btnEdit-Edit").attr("disabled", false);
            $("#btnDelete-Edit").attr("disabled", false);
        }
    };

    function UpdateRateTableUI() {
        $('#ratesTable').load("/CurrencyRates/GetCurrencyRatesTable/" + $('#CurrencyID').val(), atachEventToRatesTable);
    };

    function DeleteRate() {
        $('#deleteRateIdNum').val(rateID);
        $('#confirmDeleteRate').modal({ show: 'true' });
    };

    initCurrencyField();
    initDateTimePicker();
    UpdateRateTableUI();
    UpdateInfo();

    $('#editToolButtons').on('click', 'button[data-name="Add-Edit"]', AddRate);

    $('#editToolButtons').on('click', 'button[data-name="Edit-Edit"]', EditRate);

    $('#editToolButtons').on('click', 'button[data-name="Delete-Edit"]', DeleteRate);

    $('#btnAddEditRate').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/CurrencyRates/AddRate/?ID=' + $('#addCurrencyRateID').val() + "&CurrencyID=" + $('#CurrencyID').val() + "&Rate=" + $('#addCurrencyRateValue').val() + "&RecDate=" + $('#datetimepicker').data('date'),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#editRateModal').modal('hide');
                    UpdateRateTableUI();

                    rateID = null;
                    UpdateButtonsUI();
                }
            }
        });
    });

    $('#DeleteConfirmRate').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/CurrencyRates/DeleteRate/' + rateID,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#confirmDeleteRate').modal('hide');
                    UpdateRateTableUI();

                    rateID = null;
                    UpdateButtonsUI();
                }
            }
        });
    });

    $('#addCurrencyRateValue').on('input', UpdateInfo);

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 500;  //time in ms, 0.75 second for example
    var $inputCurrN = $('#currencyNewName');

    //on keyup, start the countdown
    $inputCurrN.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            $.ajax({
                type: "POST",
                url: '/CurrencyRates/IsUniqueCurrencyRateName/?name=' + $('#currencyNewName').val() + "&id=" + $('#CurrencyID').val(),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response != null && response.success == true) {
                        if (response.IsUnique == true) {
                            $('#uniqueCurrencyRateName2').slideUp('fast');
                            $('#btnSubmitCurrencyRate').prop('disabled', false);
                        }
                        else {
                            $('#uniqueCurrencyRateName2').slideDown('fast');
                            $('#btnSubmitCurrencyRate').prop('disabled', true);
                        }
                    }
                }
            });
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown 
    $inputCurrN.on('keydown', function () { clearTimeout(typingTimer); });
});