﻿window.ObserversIsLoaded = false;   //show, observer loaded or not
var Observers = [];             //list of all Observers

{
    let NodeLevelMargin = 7;

    let ObserversState = {};
    let ObserversEntryState = {};

    let itemsList = [];             //list of all added menu items
    let itemsLevel = [];            //list for all added menu items margin set

    String.prototype.replaceAll = function (search, replacement) {
        var target = this;
        return target.replace(new RegExp(search, 'g'), replacement);
    };

    function escapeSelectorSymbols(str, doubleSlash = false) {
        if (str)
            return str.replace(/([ #;?%&,.+*~\':"!^$[\]()=>|\/@])/g, doubleSlash ? '\\\\$1' : '\\$1');

        return str;
    }

    function BuildItem(root, id, title, level, url, ic, chevrone, hide = true) {
        /* create menu tree-item */
        var li = document.createElement('li');
        li.id = id;
        li.className = "treeItem";

        var a = document.createElement('a');
        a.setAttribute('href', url == '#' ? 'javascript:;' : url);
        a.style.marginLeft = NodeLevelMargin * level + "px";

        var icon = document.createElement('i');
        icon.id = "iconTree";
        icon.className = ic;

        var ttl = document.createElement('span');
        ttl.innerHTML = title;

        a.appendChild(icon);
        a.appendChild(ttl);

        if (chevrone) {
            var chev = document.createElement('i');
            chev.className = "fa fa-chevron-down treeChevroneRight treeChevroneSmall";

            a.appendChild(chev);
        }

        li.appendChild(a);

        $(li).insertAfter($('#' + escapeSelectorSymbols(root)));

        itemsList.push(li);
        itemsLevel.push(level);

        if (hide)
            $(li).hide();

        return li.id;
    }

    function changeLevel(item, level) {
        /*change left margin for menu items*/
        $(item).find('a').css('margin-left', NodeLevelMargin * level + "px");
    }

    function showChevron(item, show) {
        /* show or hide chevron icon*/
        if (show) {
            $(item).find($('.treeChevroneRight')).hide();
        }
        else {
            $(item).find($('.treeChevroneRight')).show();
        }
    }

    function rotateChevron(item, back) {
        /* show or hide chevron icon*/
        if (back) {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(-90deg)');
        }
        else {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(0)');
        }
    }

    function AddObserverEntries(Parent, level, id, name, isSupportActive, r) {
        BuildItem(Parent, 'OBSC_' + Parent + '_settings', $('#LeftSideLocalizationString_OBSSettings').val(), level, '/Observers/Edit/' + encodeURIComponent(name), "fa fa-cog", false);

        if (isSupportActive) {
            BuildItem(Parent, 'OBSC_' + Parent + '_acalls', $('#LeftSideLocalizationString_OBSACalls').val(), level, '/Observers/ActiveCalls/' + encodeURIComponent(name), "fa fa-phone-volume", false);
        }

        BuildItem(Parent, 'OBSC_' + Parent + '_ccalls', $('#LeftSideLocalizationString_OBSСCalls').val(), level, '/Observers/LastCalls/' + encodeURIComponent(name), "fa fa-tty", false);
        BuildItem(Parent, 'OBSC_' + Parent + '_ccdr', $('#LeftSideLocalizationString_OBSJournal').val(), level, '/Observers/LastCDR/' + encodeURIComponent(name), "fa fa-file-alt", false);

        if (!r) {
            BuildItem(Parent, 'OBSC_' + Parent + '_log', $('#LeftSideLocalizationString_OBSLog').val(), level, '/Logger/Observer/' + encodeURIComponent(name), "fa fa-file-code", false);
        }
    }

    function AddObserverManagement(Parent, s = true) {
        var mg = BuildItem(Parent, Parent + '_management', $('#LeftSideLocalizationString_OBSManagement').val(), 1, '/Observers', "fa fa-cog", false, s);
        ObserversState[mg] = s;
    }

    window.ShowObservers = function (parent, force = false) {
        //list of observers
        Observers.forEach(function (element) {
            if (force || ObserversState[element]) {
                $('#' + escapeSelectorSymbols(element)).slideDown("fast");
                ObserversState[element] = false;
            }
            else {
                CloseAllObserversContent();
                $('#' + escapeSelectorSymbols(element)).slideUp("fast");
                ObserversState[element] = true;
            }

            rotateChevron(parent, !ObserversState[element]);
        });

        //management
        if (force || ObserversState['ObserverMenu_management']) {
            $('#' + 'ObserverMenu_management').slideDown("fast");
            ObserversState['ObserverMenu_management'] = false;
        }
        else {
            $('#' + 'ObserverMenu_management').slideUp("fast");
            ObserversState['ObserverMenu_management'] = true;
        }

        //remote
        if (force || ObserversState['ObserverMenu_remote']) {
            $('#' + 'ObserverMenu_remote').slideDown("fast");
            ObserversState['ObserverMenu_remote'] = false;
        }
        else {
            $('#' + 'ObserverMenu_remote').slideUp("fast");
            ObserversState['ObserverMenu_remote'] = true;
        }
    };

    window.ShowObserversContent = function (parent, force = false) {
        if (force || !ObserversEntryState[parent]) {

            $('li[id^="OBSC_' + parent + '_settings').slideUp("fast");
            $('li[id^="OBSC_' + parent + '_acalls').slideUp("fast");
            $('li[id^="OBSC_' + parent + '_ccalls').slideUp("fast");
            $('li[id^="OBSC_' + parent + '_ccdr').slideUp("fast");
            $('li[id^="OBSC_' + parent + '_log').slideUp("fast");
            $('li[id^="OBSC_' + parent + '_setup').slideUp("fast");

            ObserversEntryState[parent] = true;
        }
        else {

            CloseAllObserversContent();

            $('li[id^="OBSC_' + parent + '_settings').slideDown("fast");
            $('li[id^="OBSC_' + parent + '_acalls').slideDown("fast");
            $('li[id^="OBSC_' + parent + '_ccalls').slideDown("fast");
            $('li[id^="OBSC_' + parent + '_ccdr').slideDown("fast");
            $('li[id^="OBSC_' + parent + '_log').slideDown("fast");
            $('li[id^="OBSC_' + parent + '_setup').slideDown("fast");

            ObserversEntryState[parent] = false;
        }

        rotateChevron(parent, !ObserversEntryState[parent]);
    };

    window.AddObserver = function (Parent, e, s = true, a = false, r = false, i = 0) {
        let id = e.replaceAll(' ', '_');

        if (Parent == null) {
            if (Observers.length == 0) {
                Parent = 'ObserverMenu';
            }
            else {
                Parent = Observers[0];
            }
        }

        var observer = BuildItem(Parent, Parent + '_' + id, e, 2, '#', r ? "fa fa-satellite" : "fa fa-satellite-dish", true, s);

        AddObserverEntries(observer, 4, id, e, a, r, i);

        Observers.push(observer);
        ObserversState[observer] = s;
        ObserversEntryState[observer] = true;

        $('#' + escapeSelectorSymbols(observer)).on('click', function () {//show observer children (abonents, limited abonents, devices)
            ShowObserversContent(observer);
        });

        return observer;
    };

    window.RenameObserver = function (OldName, NewName) {
        let e = $('#ObserverMenu_' + OldName.replaceAll(' ', '_'));
        let observer = 'ObserverMenu_' + NewName.replaceAll(' ', '_');

        $(e).find('span').html(NewName);
        e.prop('id', observer);

        Observers.push(observer);
        ObserversState[observer] = ObserversState['ObserverMenu_' + OldName.replaceAll(' ', '_')];
        ObserversEntryState[observer] = ObserversEntryState['ObserverMenu_' + OldName.replaceAll(' ', '_')];

        let settings = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_settings');
        $(settings).find('a').prop('href', '/Observers/Edit/' + encodeURIComponent(NewName));
        settings.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_settings');

        let acalls = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_acalls');
        $(acalls).find('a').prop('href', '/Observers/ActiveCalls/' + encodeURIComponent(NewName));
        acalls.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_acalls');

        let ccalls = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_ccalls');
        $(ccalls).find('a').prop('href', '/Observers/LastCalls/' + encodeURIComponent(NewName));
        ccalls.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_ccalls');

        let ccdr = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_ccdr');
        $(ccdr).find('a').prop('href', '/Observers/LastCDR/' + encodeURIComponent(NewName));
        ccdr.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_ccdr');

        let log = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_log');
        $(log).find('a').prop('href', '/Observers/Log/' + encodeURIComponent(NewName));
        log.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_log');

        let setup = $('#OBSC_ObserverMenu_' + OldName.replaceAll(' ', '_') + '_setup');
        $(setup).find('a').prop('href', '/Observers/Setup/' + encodeURIComponent(NewName));
        setup.prop('id', 'OBSC_ObserverMenu_' + NewName.replaceAll(' ', '_') + '_setup');

        $(e).unbind();
        $('#' + escapeSelectorSymbols(observer)).on('click', function () {//show observer children (abonents, limited abonents, devices)
            ShowObserversContent(observer);
        });
    };

    window.RemoveObserver = function (Name) {
        $('#ObserverMenu_' + Name.replaceAll(' ', '_')).remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_settings').remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_acalls').remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_ccalls').remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_ccdr').remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_log').remove();
        $('#OBSC_ObserverMenu_' + Name.replaceAll(' ', '_') + '_setup').remove();
    };

    function CloseAllObserversContent() {
        for (var key in ObserversEntryState) {
            if (!ObserversEntryState[key]) {

                $('li[id^="OBSC_' + key + '"]').slideUp("fast");

                ObserversEntryState[key] = true;
                rotateChevron(key, false);
            }
        }
    }

    function LoadObservers(callback = null) {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Observers/GetMenu/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    let parent = "ObserverMenu";

                    for (var i = 0; i < response.list.length; i++) {
                        parent = AddObserver("ObserverMenu", response.list[i].Name, true, response.list[i].IsSupportRealtime, response.list[i].IsRemote, response.list[i].ServerID);
                    }

                    AddObserverManagement("ObserverMenu");

                    $('#ObserverMenu').on('click', () => {
                        ShowObservers("ObserverMenu");
                    });

                    ObserversIsLoaded = true;
                }
                else {
                    console.log("Load Observers filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    $(document).ready(function () {

        /*hide chevron icon and set margin left to 0 whet menu is closing*/
        $('#MenuHamburger').on('click', function () {
            if ($('#SideMenu').width() >= 250) {
                itemsList.forEach(function (element) {
                    changeLevel(element, 0);
                    showChevron(element, true);
                });

                showChevron($('#ObserverMenu'), true);
            }
            else {
                var i = 0;
                itemsList.forEach(function (element) {
                    changeLevel(element, itemsLevel[i]);
                    showChevron(element, false);
                    i++;
                });

                showChevron($('#ObserverMenu'), false);
            }

        });

        LoadObservers();
    });
}