﻿$(document).ready(() => {
    let SelectedAddresses = [];

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateAddressesButtonUI() {
        if (SelectedAddresses.length === 0) {
            $('#btnEditaddress').prop('disabled', true);
            $('#btnDeleteaddress').prop('disabled', true);
        }
        else if (SelectedAddresses.length === 1) {
            $('#btnEditaddress').prop('disabled', false);
            $('#btnDeleteaddress').prop('disabled', false);
        }
        else {
            $('#btnEditaddress').prop('disabled', true);

            $('#btnDeleteaddress').prop('disabled', false);
        }
    }

    function AttachEventsToAddresses() {
        var header = document.getElementById("AddressHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        SelectedAddresses = [];

        $('#tariscope-addresses tbody').on('click', 'tr', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $(this).index();

                var table = $('#tariscope-addresses');

                //init first row
                if (rowIndex === null)
                    rowIndex = $(this).index();

                tempIndex = rowIndex;

                //clear prev selected
                SelectedAddresses = [];

                $('#tariscope-addresses tr.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(SelectedAddresses, tr.find('td[data-name="ID"]').text());
                            SelectedAddresses.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(SelectedAddresses, tr2.find('td[data-name="ID"]').text());
                            SelectedAddresses.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }
            }
            else {//single select
                rowIndex = $(this).index();

                SelectedAddresses = [];

                if ($(this).hasClass('selected')) {
                    $('#tariscope-addresses tr.selected').removeClass('selected');
                }
                else {
                    $('#tariscope-addresses tr.selected').removeClass('selected');
                    SelectedAddresses.push($(this).find('td[data-name="ID"]').text());
                    $(this).addClass('selected');
                }
            }

            UpdateAddressesButtonUI();
        });

        UpdateAddressesButtonUI();
    }

    function LoadAddresses() {
        $('#addressesTable').load('/Subscribers/LoadAddresses/' + $('#AbonentID').val(), AttachEventsToAddresses);
    }

    //back to abonent
    $('#btnBackToAbonentFromAddresses').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#editSection').slideDown('fast');

        //updated addresses
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAddressesNames/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#AbonentAddress1').val(response.names);
                }
            }
        });
    });

    //show modal to add address
    $('#btnAddaddress').on('click', () => {

        $('#abonent_Name').val('');
        $('#abonent_City').val('');
        $('#abonent_ZipCode').val('');
        $('#abonent_Area').val('');
        $('#abonent_Street').val('');
        $('#abonent_Building').val('');
        $('#abonent_House').val('');
        $('#abonent_Floor').val('');
        $('#abonent_Flat').val('');

        $('#btnSaveAddress').unbind();
        $('#btnSaveAddress').on('click', () => {
            ShowSpinner(true);

            var formData = new FormData();

            formData.append('Name', $('#abonent_Name').val());
            formData.append('City', $('#abonent_City').val());
            formData.append('ZipCode', $('#abonent_ZipCode').val());
            formData.append('Area', $('#abonent_Area').val());
            formData.append('Street', $('#abonent_Street').val());
            formData.append('Building', $('#abonent_Building').val());
            formData.append('House', $('#abonent_House').val());
            formData.append('Floor', $('#abonent_Floor').val());
            formData.append('Flat', $('#abonent_Flat').val());

            $.ajax({
                type: "POST",
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/Subscribers/AddAddress/' + $('#AbonentID').val(),
                success: function (response) {
                    LoadAddresses();
                    ShowSpinner(false);
                }
            });
        });

        $('#btnSaveAddress').prop('disabled', true);
        $('#AbonentAddressModal').modal('show');
    });

    //show error when empty name for a new observer
    $('#abonent_Name').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#btnSaveAddress').prop('disabled', true);
        }
        else {
            $('#btnSaveAddress').prop('disabled', false);
        }
    })

    //show modal for delete abonent plan
    $('#btnDeleteaddress').on('click', () => {
        $('#deleteAddressConfirm').prop('disabled', false);
        $('#deleteAddress').modal('show');
    });

    //confirm delete dn
    $('#deleteAddressConfirm').on('click', () => {
        $('#deleteAddress').modal('hide');
        ShowSpinner(true);

        $.ajax({
            method: 'POST',
            data: { ids: SelectedAddresses },
            dataType: "json",
            url: '/Subscribers/DeleteAddresses/',
            success: function (response) {
                ShowSpinner(false);
                LoadAddresses();
            }
        });
    });

    //show modal for edit plan
    $('#btnEditaddress').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAddresses/' + SelectedAddresses[0],
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#abonent_Name').val(response.address.Name);
                    $('#abonent_City').val(response.address.City);
                    $('#abonent_ZipCode').val(response.address.ZipCode);
                    $('#abonent_Area').val(response.address.Area);
                    $('#abonent_Street').val(response.address.Street);
                    $('#abonent_Building').val(response.address.Building);
                    $('#abonent_House').val(response.address.House);
                    $('#abonent_Floor').val(response.address.FloorNumber);
                    $('#abonent_Flat').val(response.address.Flat);

                    $('#btnSaveAddress').unbind();
                    $('#btnSaveAddress').on('click', () => {
                        ShowSpinner(true);

                        var formData = new FormData();

                        formData.append('Name', $('#abonent_Name').val());
                        formData.append('City', $('#abonent_City').val());
                        formData.append('ZipCode', $('#abonent_ZipCode').val());
                        formData.append('Area', $('#abonent_Area').val());
                        formData.append('Street', $('#abonent_Street').val());
                        formData.append('Building', $('#abonent_Building').val());
                        formData.append('House', $('#abonent_House').val());
                        formData.append('Floor', $('#abonent_Floor').val());
                        formData.append('Flat', $('#abonent_Flat').val());

                        $.ajax({
                            type: "POST",
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            url: '/Subscribers/UpdateAddress/' + SelectedAddresses[0],
                            success: function (response) {
                                LoadAddresses();
                                ShowSpinner(false);
                            }
                        });
                    });

                    $('#btnSaveAddress').prop('disabled', false);
                    $('#AbonentAddressModal').modal('show');
                }
            }
        });
    });

    LoadAddresses();
});