﻿$(document).ready(() => {
    let empty = `<br /><div class="well well-sm"><div class="text-center">${$('#LblEmpty').val()}</div></div>`;

    function ShowEditPanel() {
        $('#EditPanel').slideDown('fast');
        $('#btnShowPanel').hide('fast');

        setTimeout(Select2Init, 300);
    }

    function HideEditPanel() {
        $('#EditPanel').slideUp('fast');
        $('#btnShowPanel').show('show');
    }

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function UpdatePeriodSection() {
        let selectedValue = $('#Period').val() * 1;

        switch (selectedValue) {
            case 9:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').show();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 10:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').hide();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 11:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideDown('fast');

                try {
                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
                } catch (e) { }
                break;
            default:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideUp('fast');
                break;
        }
    }

    function Select2Init() {
        let els = $('.call-directions');

        els.each(x => {
            let val = $(`#${$(els[x]).prop('id')}_hidden`).val();

            if (val) {
                let selected = val.split(",");
                for (var i = 0; i < selected.length; i++) {
                    $(els[x]).find("option[value='" + selected[i] + "']").prop("selected", true);
                }
            }
        });

        $('.call-directions').select2({ theme: "bootstrap", placeholder: $('#txtDir').val() });
    }

    function Recalculate() {
        let i = 0;
        let pds = $('#provider-table').children();

        pds.each(x => {
            let el = $(pds[x]);

            el.prop('id', `Provider_${i}`);

            el.find('.provider-provider').prop('id', `Providers_${i}__ProviderID`);
            el.find('.provider-provider').prop('name', `Providers[${i}].ProviderID`);
            el.find('.provider-provider').data('id', i);

            el.find('.provider-calltype').prop('id', `Providers_${i}__CallTypes`);
            el.find('.provider-calltype').prop('name', `Providers[${i}].CallTypes`);

            el.find('.provider-summary').prop('id', `Providers_${i}__IncludeSummaryLine`);
            el.find('.provider-summary-lbl').prop('for', `Providers_${i}__IncludeSummaryLine`);
            el.find('.provider-summary').prop('name', `Providers[${i}].IncludeSummaryLine`);

            i++;
        });

        $(`input[name^="Providers["][type="hidden"][value="false"]`).remove();
    }

    function InitProviderEvents() {
        $('.btnDeleteProvider').unbind();
        $('.btnDeleteProvider').on('click', function () {

            let el = $(this).parent().parent().parent().parent();
            let id = el.data('id');
            el.remove();

            if ($('#provider-table').find('.provider-body').length == 0) {
                $('#provider-table').html(empty);
            }
            else {
                Recalculate();
            }
        });
    }

    function InsertEmptyProvider() {
        let template = `<div id="Provider_0" class="padding provider-body" data-id="0"><div class="info-box noSelect padding">
                            <div class="row"><div class="form-group col-md-6"><label>${$('#LblProvider').val()}</label>
                            <button type="button" class="btn btn-box-tool btnDeleteProvider" data-name="Add" data-toggle="tooltip" title="" data-original-title="${$('#LblDelete').val()}" data-placement="right">
                            <i class="fa fa-backspace fa-lg"></i></button>
                            <select class="form-control input-sm provider-provider" data-val="true" id="Providers_0__ProviderID" name="Providers[0].ProviderID">
                            ${$('#ProvidersList').html()}</select></div><div class="form-group col-md-6">
                            <label for="CallTypes" class="control-label">${$('#LblCallType').val()}</label>
                            <select class="form-control call-directions provider-calltype" id="Providers_0__CallTypes" multiple="" name="Providers[0].CallTypes">
                            ${$('#CallTypesList').html()}
                            </select></div>
                            <div class=" col-md-4 form-check" style="margin-top: 5px;">
                            <input data-val="true" hidden="hidden" id="Providers_0__IncludeSummaryLine" name="Providers[0].IncludeSummaryLine" type="checkbox" value="true" class="provider-summary">
                            <label class="switch provider-summary-lbl" for="Providers_0__IncludeSummaryLine" style="margin-bottom: 0; margin-top: 5px;"></label>
                            <span style="margin-left:5px; vertical-align: middle">${$('#LblSummaryLine').val()}</span></div></div></div></div>`;

        $('#provider-table').append(template);
        $('#provider-table').animate({ scrollTop: 99999999999999 }, 50);

        Select2Init();
        InitProviderEvents();
        Recalculate();
    }

    function Load() {
        ShowSpinner(true);
        $('#ResultPanel').load(`/ProviderViews/Load/?${$('#ViewFrom').serialize()}`, () => { ShowSpinner(false); });
    }

    //show section for enter custom view period
    $('#Period').change(UpdatePeriodSection);

    //when window resized
    $(window).on('resize', Select2Init);

    //add empty provider
    $('#btnAddProvider').on('click', () => {
        if ($('#provider-table').find('.provider-body').length == 0) {
            $('#provider-table').empty();
        }

        InsertEmptyProvider();
    });

    //show panel
    $('#btnShowPanel').on('click', ShowEditPanel);

    //hide edit panel
    $('#btnHidePanel').on('click', HideEditPanel);

    //close left menu
    setTimeout(() => {
        if (window.innerWidth > 767)
            $('#MenuHamburger').click();
    }, 500);

    //save view
    $('#ViewFrom').submit(function (e) {
        ShowSpinner(true);

        var data = new FormData(this);
        e.preventDefault();

        $.ajax({
            url: `/ProviderViews/Save?OldName=${$('#OldViewName').val()}&NewName=${$('#ViewName').val()}&OwnerType=${$('#OwnerType').val()}&OwnerName=${$('#ViewOwner').val()}&Group=${$('#ViewGroup').val()}&IsNew=${$('#ViewIsNew').val() * 1 == 1}`,
            type: 'POST',
            data: data,
            success: function (response) {
                ShowSpinner(false);
                if (response.success) {
                    $('#OldViewName').val($('#ViewName').val());
                    $('#ViewIsNew').val(0);
                }
                else {
                    $('#ErrorSavingModal').modal('show');
                }
            },
            error: function () {
                ShowSpinner(false);
                $('#ErrorSavingModal').modal('show');
            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    });

    //apply filter
    $('#applyBtn').on('click', Load);

    //export to excel
    $('#btnExportToExcel').on('click', () => {
        if ($('#tariscope-provider-summary').length > 0)
            new Table2Excel('#tariscope-provider-summary').export($('#ViewName').val());
    });

    UpdatePeriodSection();
    initDateTimepickers();
    Select2Init();
    InitProviderEvents();
    Load();
});