﻿$(document).ready(() => {
    let GlobalFilter = {
        period: $('#PeriodType').val(),
        year: $('#SelectedYear').val(),
        month: $('#SelectedMonthValue').val(),
        from: '',
        fromEnabled: $('#PeriodFromEnable').prop('checked'),
        to: '',
        toEnabled: $('#PeriodToEnable').prop('checked'),
        department: $('#SourceDepartment').length > 0 ? $('#SourceDepartment').val() : '-2'
    };

    let windowHeight;
    let clusterize;
    let rowIndex;

    let ClasterSize = 50;
    let Loadsize = ClasterSize * 5;
    let LoadedRows = 0;

    let SelectedRows = [];
    let SelectedField;
    let SelectedValue;
    let SelectedType;
    let SelectedRelated;

    let request = null;

    let requestForExport = null;

    let ctrlDown = false;
    let ctrlKey = 17;
    let cmdKey = 91;
    let xKey = 88;
    let cKey = 67;

    let SelectedOnly;

    //Name of fields that must be selected to enable "Add to Phonebook" button
    const NumberAFieldName = "NumberA"
    const NumberBFieldName = "NumberB"

    //Arrays for number filter
    let selectedNumbers = [];

    function BuildUrl(method, fields = {}) {
        //const fields
        let url = `/PersonalArea/Statistic/${method}/?Name=${encodeURIComponent($('#ViewName').val())}&Type=${ConvertViewTypeModelToInt($('#ViewType').val())}&Count=${(ClasterSize * 100)}`;

        //custom fields
        for (key in fields) {
            url += `&${key}=${fields[key]}`;
        }

        return url;
    }

    function GetDate(name) {
        let dt = $('#' + name).data("DateTimePicker").getDate();
        let y = dt.year() + '';
        let m = dt.month() + 1;
        let d = dt.date();
        let h = dt.hours();
        let M = dt.minutes();
        let s = dt.seconds();

        if (m < 10)
            m = '0' + m;

        if (d < 10)
            d = '0' + d;

        if (h < 10)
            h = '0' + h;

        if (M < 10)
            M = '0' + M;

        if (s < 10)
            s = '0' + s;

        return `${y}${m}${d}${h}${M}${s}`;
    }

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            sideBySide: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);

        $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
        $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateButtons() {
        if (SelectedField === null && SelectedValue === null && SelectedType === null && SelectedRows.length === 0) {
            $('button[data-selected="1"]').prop('disabled', true);
            $('.menulist').find('a[data-menuhide="1"]').addClass('disDiv');
        }
        else {
            $('button[data-selected="1"]').prop('disabled', false);
            $('.menulist').find('a[data-menuhide="1"]').removeClass('disDiv');
        }

        if ((SelectedField === NumberAFieldName || SelectedField === NumberBFieldName) && SelectedValue)
            $('#btnAddToPhoneBook').prop('disabled', false);
        else
            $('#btnAddToPhoneBook').prop('disabled', true);

        if (!$('#NewContactName').val() || !$('#NewContactName').val().trim()) {
            $('#btnSaveNewContact').prop('disabled', true);
        }
        else {
            $('#btnSaveNewContact').prop('disabled', false);
        }

        if ($('#groupMark').length === 0) {//NOT GROUPED
            $('#btnDetailsAll').removeClass('disDiv');
            $('#btnFilterUnGroup').prop('disabled', true);

            $('#btnDetailsAllMenu').removeClass('disDiv');
            $('#btnDetailsAllBlankMenu').removeClass('disDiv');
            $('#btnFilterUnGroupMenu').addClass('disDiv');

            if (SelectedRows.length === 0) {
                $('#btnRecharge').prop('disabled', true);
                $('#btnDeleteSelected').prop('disabled', true);
                $('#btnFilterRelated').prop('disabled', true);
                $('#btnDetailsSelected').addClass('disDiv');
                $('#btnDetailsSelectedBlank').addClass('disDiv');

                $('#btnRechargeMenu').addClass('disDiv');
                $('#btnDetailsSelectedMenu').addClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
                $('#btnFilterRelatedMenu').addClass('disDiv');
                $('#btnDeleteSelectedMenu').addClass('disDiv');
            }
            else {
                $('#btnRecharge').prop('disabled', false);
                $('#btnDeleteSelected').prop('disabled', false);
                $('#btnFilterRelated').prop('disabled', false);
                $('#btnDetailsSelected').removeClass('disDiv');
                $('#btnDetailsSelectedBlank').removeClass('disDiv');

                $('#btnRechargeMenu').removeClass('disDiv');
                $('#btnDetailsSelectedMenu').removeClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').removeClass('disDiv');
                $('#btnFilterRelatedMenu').removeClass('disDiv');
                $('#btnDeleteSelectedMenu').removeClass('disDiv');
            }

            if ($('#ViewType').val() !== "Calls") {
                $('#btnFilterRelated').prop('disabled', true);//related -> only calls
                $('#btnDeleteSelected').prop('disabled', true);//delete -> only calls
                $('#btnRecharge').prop('disabled', true);//recharge -> only calls
                $('#btnDetailsSelected').addClass('disDiv');//details -> only calls
                $('#btnDetailsSelectedBlank').addClass('disDiv');//details -> only calls
                $('#btnDetailsAll').addClass('disDiv');//details -> only calls

                $('#btnRechargeMenu').addClass('disDiv');
                $('#btnDetailsSelectedMenu').addClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
                $('#btnDetailsAllMenu').addClass('disDiv');
                $('#btnDetailsAllBlankMenu').addClass('disDiv');
                $('#btnFilterRelatedMenu').addClass('disDiv');
                $('#btnDeleteSelectedMenu').addClass('disDiv');
            }

            if ($('#ViewType').val() !== "Calls") {
                $('#btnRechargeAll').prop('disabled', true);//recharge -> only calls
                $('#btnRechargeAllMenu').addClass('disDiv');

                $('#btnCategoryAll').prop('disabled', true);
                $('#btnCategoryAllMenu').addClass('disDiv');
            }
            else {
                $('#btnRechargeAll').prop('disabled', false);//recharge -> only calls
                $('#btnRechargeAllMenu').removeClass('disDiv');

                $('#btnCategoryAll').prop('disabled', false);
                $('#btnCategoryAllMenu').removeClass('disDiv');
            }


        }
        else {//GROUPED
            $('#btnFilterUnGroup').prop('disabled', false);
            $('#btnFilterUnGroupMenu').removeClass('disDiv');

            $('#btnRecharge').prop('disabled', true);
            $('#btnDeleteSelected').prop('disabled', true);
            $('#btnFilterRelated').prop('disabled', true);

            $('#btnRechargeAll').prop('disabled', true);
            $('#btnCategoryAll').prop('disabled', true);

            $('#btnDetailsSelected').addClass('disDiv');//details -> only calls
            $('#btnDetailsAll').addClass('disDiv');//details -> only calls

            $('#btnRechargeMenu').addClass('disDiv');
            $('#btnRechargeAllMenu').addClass('disDiv');
            $('#btnCategoryAllMenu').addClass('disDiv');
            $('#btnDetailsAllMenu').addClass('disDiv');
            $('#btnDetailsAllBlankMenu').addClass('disDiv');
            $('#btnDetailsSelectedMenu').addClass('disDiv');
            $('#btnDetailsSelected').addClass('disDiv');
            $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
            $('#btnDetailsSelectedBlank').addClass('disDiv');
            $('#btnFilterRelatedMenu').addClass('disDiv');
            $('#btnDeleteSelectedMenu').addClass('disDiv');

        }

        if (SelectedRows.length === 0) {
            $('#btnFilterSort').prop('disabled', true);
            $('#btnFilterUnSortSelected').prop('disabled', true);
            $('#btnFilterGroup').prop('disabled', true);

            $('#btnCopyCell').prop('disabled', true);
            $('#btnCopyRow').prop('disabled', true);

            $('#btnFilterSortMenu').addClass('disDiv');
            $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            $('#btnFilterGroupMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterSort').prop('disabled', false);
            $('#btnFilterGroup').prop('disabled', false);

            $('#btnCopyCell').prop('disabled', false);
            $('#btnCopyRow').prop('disabled', false);

            $('#btnFilterSortMenu').removeClass('disDiv');
            $('#btnFilterGroupMenu').removeClass('disDiv');

            if ($("i[data-sfield='" + SelectedField + "']").length === 0) {
                $('#btnFilterUnSortSelected').prop('disabled', true);
                $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            }
            else {
                $('#btnFilterUnSortSelected').prop('disabled', false);
                $('#btnFilterUnSortSelectedMenu').removeClass('disDiv');
            }
        }

        if (SelectedRows.length > 1) {
            $('#btnFilterEq').prop('disabled', true);
            $('#btnFilterNotEq').prop('disabled', true);
            $('#btnFilterRelated').prop('disabled', true);
            $('#btnFilterSort').prop('disabled', true);
            $('#btnFilterUnSortSelected').prop('disabled', true);
            $('#btnFilterGroup').prop('disabled', true);

            $('#btnCopyCell').prop('disabled', true);
            $('#btnCopyRow').prop('disabled', true);
            $('#btnCopyCellMenu').addClass('disDiv');
            $('#btnCopyRowMenu').addClass('disDiv');

            $('#btnFilterEqMenu').addClass('disDiv');
            $('#btnFilterNotEqMenu').addClass('disDiv');
            $('#btnFilterRelatedMenu').addClass('disDiv');
            $('#btnFilterSortMenu').addClass('disDiv');
            $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            $('#btnFilterGroupMenu').addClass('disDiv');
        }

        let current = $('#CurrentFilterIndex').val() * 1;
        let count = $('#CountFilters').val() * 1;

        if (current < 0) {
            $('#btnFilterPrev').prop('disabled', true);
            $('#btnFilterPrevMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterPrev').prop('disabled', false);
            $('#btnFilterPrevMenu').removeClass('disDiv');
        }

        if (current === (count - 1)) {
            $('#btnFilterNext').prop('disabled', true);
            $('#btnFilterNextMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterNext').prop('disabled', false);
            $('#btnFilterNextMenu').removeClass('disDiv');
        }

        if (count === 0) {
            $('#btnFilterClear').prop('disabled', true);
            $('#btnFilterClearMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterClear').prop('disabled', false);
            $('#btnFilterClearMenu').removeClass('disDiv');
        }

        if ($('#sortMark').length === 0) {
            $('#btnFilterUnSort').prop('disabled', true);
            $('#btnFilterUnSortMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterUnSort').prop('disabled', false);
            $('#btnFilterUnSortMenu').removeClass('disDiv');
        }
    }

    function UpdateCount(rowlimited = false, loaded = false) {
        //update informaiton about rows count
        LoadedRows = clusterize.getRowsAmount();
        $('#totalLines').text(LoadedRows);

        $('#ForLoadMore').hide();

        if (loaded === true) {
            $('#loadedLabel').show();

            if (rowlimited === true) {
                $('#ForLoadMore').show();
            }
        }
        else {
            $('#loadedLabel').hide();

            if (rowlimited === true) {
                $('#ForLoadMore').hide();
            }
        }

        SetHeight();
    }

    function AttachEventsToTable() {
        clusterize = new Clusterize({
            scrollId: 'scrollArea',
            contentId: 'contentArea',
            rows_in_block: ClasterSize
        });

        //click to row or cell
        $('#contentArea').on('click', 'td', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                var table = $('#tariscope-view');

                //init first row
                if (rowIndex === null)
                    rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                tempIndex = rowIndex;

                //clear prev selected
                SelectedRows = [];
                SelectedField = null;
                SelectedValue = null;
                SelectedType = null;
                SelectedRelated = null;

                $('#tariscope-view tr.selected').removeClass('selected');
                $('#tariscope-view td.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(SelectedRows, tr.find('td[data-name="ID"]').text());
                            SelectedRows.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(SelectedRows, tr2.find('td[data-name="ID"]').text());
                            SelectedRows.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }

                if (SelectedRows.length >= 100) {
                    $('#toMuchSelecteModal').modal('show');
                }

            }
            else {//single select
                rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                SelectedRows = [];
                SelectedField = null;
                SelectedValue = null;
                SelectedType = null;
                SelectedRelated = null;

                if ($(this).hasClass('selected')) {
                    $('#tariscope-view tr.selected').removeClass('selected');
                    $('#tariscope-view td.selected').removeClass('selected');
                }
                else {
                    $('#tariscope-view tr.selected').removeClass('selected');
                    $('#tariscope-view td.selected').removeClass('selected');

                    SelectedRows.push($(this).data('id'));

                    if ($(this).data('selector') === false) {
                        SelectedField = $(this).data('name');
                        SelectedValue = $(this).data('value');
                        SelectedType = $(this).data('type');
                        SelectedRelated = $(this).data('related-id');
                        $(this).addClass('selected');
                    }
                    else {
                        $('tr[data-id="' + $(this).data('id') + '"]').addClass('selected');
                    }
                }
            }

            UpdateButtons();
        });

        $('#NewContactName').on('input', () => {
            if (!$('#NewContactName').val() || !$('#NewContactName').val().trim()) {
                $('#emptyName').slideDown('fast');
                $('#btnSaveNewContact').prop('disabled', true);
            }
            else {
                $('#emptyName').slideUp('fast');
                $('#btnSaveNewContact').prop('disabled', false);
            }
        });

        SetHeight();
        ShowSpinner(false);

        SelectedRows = [];
        SelectedField = null;
        SelectedValue = null;
        SelectedType = null;
        SelectedRelated = null;

        UpdateButtons();
        UpdateCount();
        LoadPartialCalls();
    }

    function LoadCalls() {
        $('#viewsRowsTable').load(BuildUrl('Read'), AttachEventsToTable);
    }

    function LoadPartialCalls() {
        request = $.ajax({
            type: "POST",
            async: true,
            url: BuildUrl('ReadPartial', { Start: LoadedRows }),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    clusterize.append(response.rows);
                    UpdateCount(response.showLimit, response.loaded);


                    if (response.loaded === false) {
                        LoadPartialCalls();
                    }

                }
            }
        });
    }

    function SetHeight() {
        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('#totalData').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('.clusterize-scroll').css('max-height', windowHeight + 'px');
    }

    function GetRefreshInterval() {
        let interval = new URL(window.location.href).searchParams.get("RefreshInterval");
        return interval;
    }

    function SetRefreshInterval(value) {
        var url = new URL(window.location.href);
        url.searchParams.set("RefreshInterval", value);
        return url;
    }

    function LookToReload() {
        let interval = GetRefreshInterval();
        if (interval && interval * 1 > 0)
            setTimeout(() => {
                location.reload();
            }, interval);
    }

    function ShowCopiedMessage() {
        $('.copied-message').fadeIn('fast');

        setTimeout(() => {
            $('.copied-message').fadeOut('fast');
        }, 1000);
    }

    function CopyCell() {
        let value = $('.selected').text();

        const el = document.createElement('textarea');
        el.value = value ? value : " ";
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    }

    function CopyRow() {
        let row = $('.selected').closest('tr');
        let value = "";
        $(row).find('td').each(function () {
            value += `${$(this).text()} `;
        });

        const el = document.createElement('textarea');
        el.value = value ? value : " ";
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    }

    function Export(t) {

        if (requestForExport !== null) {
            console.log("Export in action, try later");
            return;
        }

        console.log("export to " + t);

        $('#exportingProgressError').hide();
        $('#exportingProgress').show();
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        requestForExport = $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: BuildUrl('ExportData', { ExportType: t }),
            traditional: true,
            success: function (response) {
                $('#exportingProgress').hide();

                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/PersonalArea/Statistic/DownloadExportData/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                    $('#exportingProgressError').show();
                }

                requestForExport = null;
            },
            error: function (xhr, ajaxOptions, thrownError) {
                requestForExport = null;
                console.log(`${ajaxOptions} ${xhr.status} - ${thrownError}`);
                $('#exportingProgress').hide();
                $('#exportingProgressError').show();
            }
        });
    }

    //resize window
    $(window).resize(() => {
        SetHeight();
        clusterize.refresh();
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });


    //copy cell
    $('#btnCopyCell').on('click', () => {
        CopyCell();
    });

    //copy row
    $('#btnCopyRow').on('click', () => {
        CopyRow();
    });

    //handle ctrl pressed
    $(document).keydown(function (e) {
        if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = true;
    }).keyup(function (e) {
        if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = false;
    });

    //handle x and c pressed
    $(document).keydown(function (e) {
        //copy cell
        if (ctrlDown && (e.keyCode == cKey)) {
            CopyCell();
            ShowCopiedMessage();
        }

        //copy row
        if (ctrlDown && (e.keyCode == xKey)) {
            CopyRow();
            ShowCopiedMessage();
        }
    });

    //filter by selection
    $('#btnFilterEq').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_FQ', {
            FieldName: encodeURIComponent(SelectedField),
            FieldValue: encodeURIComponent(SelectedValue),
            FieldType: encodeURIComponent(SelectedType)
        }), AttachEventsToTable);
    });

    //exclude filter by selection
    $('#btnFilterNotEq').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_NFQ', {
            FieldName: encodeURIComponent(SelectedField),
            FieldValue: encodeURIComponent(SelectedValue),
            FieldType: encodeURIComponent(SelectedType)
        }), AttachEventsToTable);
    });

    //go to prev filter
    $('#btnFilterPrev').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Prev'), AttachEventsToTable);
    });

    //go to next filter
    $('#btnFilterNext').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Next'), AttachEventsToTable);
    });

    //clear filter
    $('#btnFilterClear').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Clear'), () => {
            $('#PeriodType option[value=0]').attr('selected', true);
            $('#CustomPeriodSection').slideUp('fast');
            $('#SelectedMonth').hide();
            $('#SelectedYearMonthSection').slideUp('fast');
            AttachEventsToTable();
        });
    });

    //show modal to start/stop refresh
    $('#btnStartAutoRefresh').on('click', () => {
        let interval = GetRefreshInterval();
        if (interval && interval * 1 > 0) {
            $('#refreshInterval').val(interval / 1000);
        }
        else {
            $('#refreshInterval').val(0);
        }

        $('#refreshWindowModal').modal('show');
    });

    //set refresh interval
    $('#saveRefreshInterval').on('click', () => {
        $('#refreshWindowModal').modal('hide');
        let interval = $('#refreshInterval').val() * 1000;
        setTimeout(() => {
            window.location = SetRefreshInterval(interval);
        }, interval);
    });

    //show modal for select sort direction
    $('#btnFilterSort').on('click', () => { $('#sortViewmodal').modal('show'); });

    //confirm sorting
    $('#SortViewConfirm').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_Sort', {
            FieldName: encodeURIComponent(SelectedField),
            IsAsc: encodeURIComponent($('#selectSortDirection').val())
        }), AttachEventsToTable);
    });

    //unsort selected
    $('#btnFilterUnSortSelected').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_UnSortSelected', { FieldName: encodeURIComponent(SelectedField) }), AttachEventsToTable);
    });

    //unsort all
    $('#btnFilterUnSort').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_UnSort'), AttachEventsToTable);
    });

    //show modal for select grouping
    $('#btnFilterGroup').on('click', () => { $('#groupViewmodal').modal('show'); });

    //confirm grouping
    $('#GroupViewConfirm').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#groupViewmodal').modal('hide');

        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_Group', {
            FieldName: encodeURIComponent(SelectedField),
            GroupType: encodeURIComponent($('#selectGrouping').val())
        }), AttachEventsToTable);
    });

    //reset grouping
    $('#btnFilterUnGroup').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_UnGroup'), AttachEventsToTable);
    });

    //open modal for select fields
    $('#btnFilterSelectColls').on('click', () => {
        $('#FieldsContainer').load('/PersonalArea/Statistic/GetFields?Name=' + encodeURIComponent($('#ViewName').val()) +
            '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
            '&FieldName=' + encodeURIComponent(SelectedField), () => {
                //move buttons (top down)
                $('.tcxField').mouseover(function () {
                    $(this).append($('#btnsTopDown'));
                });

                //mode top
                $('#btnMoveTcxFieldTop').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let PrevElement = $(this).parent().parent().prev();

                    if (PrevElement.length > 0) {
                        let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let PrevInput = $(InputToMove).prev();
                        let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

                        $(CurrentElement).insertBefore($(PrevElement));

                        if (ExpectPrevNumber === RealPrevNumber)
                            $(InputToMove).insertBefore(PrevInput);
                    }
                });

                //mode down
                $('#btnMoveTcxFieldDown').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let NextElement = $(this).parent().parent().next();

                    if (NextElement.length > 0) {
                        let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let NextInput = $(InputToMove).next();
                        let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

                        $(CurrentElement).insertAfter($(NextElement));

                        if (ExpectNextNumber === RealNextNumber)
                            $(InputToMove).insertAfter(NextInput);
                    }
                });

                $('#FieldsEditor').modal('show');
            });
    });

    //open view with new fields
    $('#btnSaveFields').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#FieldsEditor').modal('hide');
        ShowSpinner(true);

        var f = $("[id^='field_']");
        var v = [];

        f.map(function (e) {
            if ($(f[e]).prop('checked'))
                v.push($(f[e]).data('field'));
        });

        $('#viewsRowsTable').load(BuildUrl('SetFields', { Fields: v.join(',') }), AttachEventsToTable);
    });

    //show modal to change category for selected
    $('#btnCategory').on('click', () => {
        $('#SetupCallCategoryModal').modal('show');
    });

    //chnage categories
    $('#btnApplyCategory').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('UpdateCategory', {
            IDs: encodeURIComponent(SelectedRows.join(",")),
            CategoryID: $('#CallNewCategory').val()
        }), AttachEventsToTable);
    });

    //load other calls
    $('#disableRowLimit').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/PersonalArea/Statistic/DisableRowLimit',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ForLoadMore').hide();
                    $('#loadedLabel').hide();
                    LoadPartialCalls();
                }
            }
        });
    });

    //show section for enter custom view period
    $('#PeriodType').change(function () {
        switch ($(this).val() * 1) {
            case 9:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').show();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 10:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').hide();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 11:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideDown('fast');

                try {
                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
                } catch (e) { }
                break;
            default:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideUp('fast');
                break;
        }

    });

    //show global filter modal
    $('#btnGlobalFilter').on('click', () => { $('#GlobalFolterModal').modal('show'); });

    //apply global filter
    $('#ApplyGlobalFolterBtn').on('click', () => {
        GlobalFilter.period = $('#PeriodType').val();
        GlobalFilter.year = $('#SelectedYearValue').val();
        GlobalFilter.month = $('#SelectedMonthValue').val();
        GlobalFilter.from = GetDate('datetimepickerFrom');
        GlobalFilter.to = GetDate('datetimepickerTo');
        GlobalFilter.department = $('#SourceDepartment').length > 0 ? $('#SourceDepartment').val() : '-2';
        GlobalFilter.fromEnabled = $('#PeriodFromEnable').prop('checked');
        GlobalFilter.toEnabled = $('#PeriodToEnable').prop('checked');

        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }
        ShowSpinner(true);

        let url = BuildUrl('Read_Date');
        
        for (key in GlobalFilter) {
            url += `&gf.${key}=${GlobalFilter[key]}`;
        }

        $('#viewsRowsTable').load(
            url,
            () => {
                AttachEventsToTable();
                ShowSpinner(false);
            }
        )
    });

    //update category button
    if (($('#ViewName').val() == 'calls' || $('#ViewName').val() == 'group_calls')
        && $('#CategoryChangeSection').length > 0) {
        $('#CategoryChangeSection').show();
    }
    else {
        $('#CategoryChangeSection').hide();
    }

    //add NumberA or NumberB to phone book
    $('#btnAddToPhoneBook').on('click', () => {
        $('#AddToPhoneBookModal').modal('show');
        $('#NewContactName').val('');
        $('#NewContactNumber').val(SelectedValue);
    })

    $('#btnSaveNewContact').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: `/PersonalArea/Service/PhoneBook/Add?Extension=${SelectedValue}&Name=${$('#NewContactName').val()}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadedRows = 0;
                    if (request !== null) {
                        request.abort();
                    }
                    ShowSpinner(true);
                    LoadCalls();
                }
            }
        });
    });

    $('#btnSaveChanges').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: BuildUrl('SaveChanges'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    $('#SuccessDialog').modal('show');
                }
            }
        });
    })

    $('#SuccessDialogOkButton').on('click', () => {
        $('#SuccessDialog').modal('hide');
    })

    $('#btnFilterByNumbers').on('click', () => {
        ShowSpinner(true);
        $('#numbersContainer').load('/PersonalArea/Statistic/GetGroupNumbers', () => {
            ShowSpinner(false);
            $('#ChooseNumbersDialog').modal('show');
            AttachEventsForSDTables()
        })
    })

    $('#btnChooseNumbers').on('click', () => {
        ShowSpinner(true);

        $('#viewsRowsTable').load(BuildUrl('Read_Numbers', { numbersStr: selectedNumbers }), () => {
            LoadedRows = 0;
            if (request !== null) {
                request.abort();
            }
            AttachEventsToTable();
            ShowSpinner(false);
        })
    }) 

    $('#btnResetNumbersSelection').on('click', () => {
        $('#tariscope-SDD tbody tr.selected').removeClass('selected');
        $('#btnResetNumbersSelection').prop('disabled', true);
        selectedNumbers = [];
    })

    function AttachEventsForSDTables() {

        selectedNumbers = [];

        if (selectedNumbers.length === 0)
            $('#btnResetNumbersSelection').prop('disabled', true)
        else
            $('#btnResetNumbersSelection').prop('disabled', false)

        //attach events to table with destination and source
        $('#tariscope-SDD tbody').on('click', 'tr', function () {
            let hidden = $(this).find('td[data-name="SDDataHidden"]').text();

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                RemoveFromArray(selectedNumbers, hidden);
            }
            else {
                if ($(this).data('name') !== 'SDDataNonSelect') {
                    selectedNumbers.push(hidden);
                    $(this).addClass('selected');
                }
            }

            if (selectedNumbers.length === 0)
                $('#btnResetNumbersSelection').prop('disabled', true)
            else
                $('#btnResetNumbersSelection').prop('disabled', false)
        });

        $('#tariscope-SDD tbody tr').each((index, element) => {
            let hidden = $(element).find('td[data-name="SDDataHidden"]').text();

            if (selectedNumbers.includes(hidden)) {
                $(element).addClass('selected');
            }
        });

        let inputs = $('#tariscope-SDD').find('input');

        if (inputs.length) {
            let search = $(inputs[0]);
            search.val('');
            search.unbind();
            search.on('input', () => {
                let str = search.val();

                if (!str || !str.trim()) {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        $(this).show();
                    });
                }
                else {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                            $(this).show();
                        }
                        else {
                            $(this).hide();
                        }
                    });
                }
            });
        }
    }

    ShowSpinner(true);
    initDateTimepickers();
    setTimeout(() => {
        if (window.innerWidth > 767)
            $('#MenuHamburger').click();
    }, 500);
    LoadCalls();
    LookToReload();
});