﻿const loader = `<td colspan="9"><div class="well well-sm"><div class="text-center padding"><i class="fas fa-spinner fa-spin fa-6x"></i></div></div></td>`;

function LoadDetails(order) {
    $('.mainrow').removeClass('selected');
    $(`tr[data-mainrow="${order}"]`).addClass('selected');
    $('.detailrow').hide();
    $('.detailrow').html('');

    let row = $(`tr[data-detailsrow="${order}"]`);
    row.show();
    row.html(loader);
    row.load('/EmployeeArea/Details/' + order);
}

$(document).ready(() => {
    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function PrepareFilter() {
        $('input[type="hidden"][name="PeriodFromEnable"][value="false"]').remove();
        $('input[type="hidden"][name="PeriodToEnable"][value="false"]').remove();

        $('input[type="hidden"][name="TypeNew"][value="false"]').remove();
        $('input[type="hidden"][name="TypeInAction"][value="false"]').remove();
        $('input[type="hidden"][name="TypeInActionExpired"][value="false"]').remove();
        $('input[type="hidden"][name="TypeCompleted"][value="false"]').remove();
        $('input[type="hidden"][name="TypeCanceled"][value="false"]').remove();

        $('#TypeNew').prop('checked', true);
        $('#TypeInAction').prop('checked', true);
        $('#TypeInActionExpired').prop('checked', true);
    }

    function Load() {
        let url = `/EmployeeArea/Load/?From=${encodeURIComponent($('#datetimepickerFrom').data('date'))}&To=${encodeURIComponent($('#datetimepickerTo').data('date'))}&FromEnabled=${$('#PeriodFromEnable').prop('checked')}&ToEnabled=${$('#PeriodToEnable').prop('checked')}`;
        url += `&New=${$('#TypeNew').prop('checked')}`;
        url += `&InAction=${$('#TypeInAction').prop('checked')}`;
        url += `&Canceled=${$('#TypeCanceled').prop('checked')}`;
        url += `&Completed=${$('#TypeCompleted').prop('checked')}`;

        $('#joborderstable').load(url, TableEvents);
    }

    function TableEvents() {
        //load details
        $('.mainrow').on('click', function () {
            let order = $(this).data('mainrow');
            LoadDetails(order);
        });
    }

    //show modal to filter
    $('#btnFilter').on('click', () => { $('#FilterOrderModal').modal('show'); });

    //checked from
    $('#PeriodFromEnable').change(() => {
        if ($('#PeriodFromEnable').prop('checked')) {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
        }
        else {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(null);
        }
    });

    //checked to
    $('#PeriodToEnable').change(() => {
        if ($('#PeriodToEnable').prop('checked')) {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
        }
        else {
            $('#datetimepickerTo').data("DateTimePicker").setDate(null);
        }
    });

    //apply filter
    $('#ApplyFilterBtn').on('click', Load);

    initDateTimepickers();
    PrepareFilter();
    Load();
});