﻿$(document).ready(() => {
    let year;
    let month;
    let day;
    let pbx;
    let description;

    function UpdateMainButtonsUI() {
        if (year == null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-ddays tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                year = null;
                month = null;
                day = null;
                description = null;
                pbx = null;
            }
            else {
                year = $(this).find('td[data-name="Year"]').text();
                month = $(this).find('td[data-name="Month"]').text();
                day = $(this).find('td[data-name="Day"]').text();
                description = $(this).find('td[data-name="Description"]').text();
                pbx = $(this).find('td[data-name="PBX"]').text();
                $('#tariscope-ddays tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/DamagedDays/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        LoadTable();
                    }
                }
            });
        });

        UpdateMainButtonsUI();
    }

    function LoadTable() {
        year = null;

        $('#ddaysTable').load(encodeURI('/DamagedDays/Load/?s=' + encodeURIComponent($('#tbSearch').val())), AttachEventsMainTable);
    }

    function initDateTimePicker() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(options);
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/DamagedDays/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/DamagedDays/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadTable();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //add a new dday
    $('#btnAdd').on('click', () => {
        $('#btnDDConfirm').unbind();

        $('#DDDescription').val('');
        $('#datetimepicker').data("DateTimePicker").setDate(new Date());
        $('#DDModalTitle').text($('#TitleAdd').val());
        $('#DDPBX').val('-1');

        //add
        $('#btnDDConfirm').on('click', () => {
            ShowSpinner(true);

            let dt = $('#datetimepicker').data("DateTimePicker").getDate();
            let y = dt.year();
            let m = dt.month() + 1;
            let d = dt.date();

            $.ajax({
                type: "POST",
                async: true,
                url: `/DamagedDays/Add/${y}/${m}/${d}/${$('#DDPBX').val()}/?Description=${encodeURIComponent($('#DDDescription').val())}`,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);

                    if (response.success) {
                        LoadTable();
                    }
                    else {
                        $('#ErrorModal').modal('show');
                    }
                }
            });
        });

        $('#DDModal').modal('show');
    });

    //edit the dday
    $('#btnEdit').on('click', () => {
        $('#btnDDConfirm').unbind();

        $('#DDDescription').val(description);
        $('#DDPBX').val(pbx);
        $('#datetimepicker').data("DateTimePicker").setDate(new Date(year, month - 1, day));
        $('#DDModalTitle').text($('#TitleEdit').val());

        //edit
        $('#btnDDConfirm').on('click', () => {
            ShowSpinner(true);

            let dt = $('#datetimepicker').data("DateTimePicker").getDate();
            let y = dt.year();
            let m = dt.month() + 1;
            let d = dt.date();

            $.ajax({
                type: "POST",
                async: true,
                url: `/DamagedDays/Update/${year}/${month}/${day}/${pbx}/${y}/${m}/${d}/${$('#DDPBX').val()}/?Description=${encodeURIComponent($('#DDDescription').val())}`,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);

                    if (response.success) {
                        LoadTable();
                    }
                    else {
                        $('#ErrorModal').modal('show');
                    }
                }
            });
        });

        $('#DDModal').modal('show');
    });

    //delete selected
    $('#btnDelete').on('click', () => { $('#DeleteSelectedModal').modal('show'); });
    $('#ConfirmDeleteSelected').on('click', () => {
        $('#DeleteSelectedModal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: `/DamagedDays/Delete/${year}/${month}/${day}/${pbx}`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    //delete all
    $('#btnDeleteAll').on('click', () => { $('#DeleteAllModal').modal('show'); });
    $('#ConfirmDeleteAll').on('click', () => {
        $('#DeleteAllModal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: `/DamagedDays/DeleteAll`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    LoadTable();
    initDateTimePicker();
});