﻿$(document).ready(function () {

    var selectedCurrencyRateID = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/CurrencyRates/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/CurrencyRates/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!")
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedCurrencyRateID = null;
        }
        else {
            selectedCurrencyRateID = e.find('td[data-name="ID"]').text();
            $('#tariscope-rates tr.selected').removeClass('selected');
            e.addClass('selected');
        }

        UpdateButtonsUI();
    }

    function atachEventToTable() {
        var header = document.getElementById("curencyHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        $('#tariscope-rates tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-rates tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedCurrencyRateID != null)
                EditCurrency();
        });

        /*attach events for export*/
        $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
        $('#ExportHTML').on('click', function () { Export("html"); });
        $('#ExportCSV').on('click', function () { Export("csv"); });
        $('#ExportPDF').on('click', function () { Export("pdf"); });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/CurrencyRates/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTableUI($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTableUI(s) { $('#currencyTable').load(encodeURI("/CurrencyRates/Search/?search=" + s), atachEventToTable); }

    function UpdateButtonsUI() {
        if (selectedCurrencyRateID === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnRename").attr("disabled", true);
            $("#btnSetMain").attr("disabled", true);
            $("#btnUpdateRate").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnRename").attr("disabled", false);
            $("#btnSetMain").attr("disabled", false);
            $("#btnUpdateRate").attr("disabled", false);
        }
    }

    function AddCurrency() {
        $('#addCurrencyModal').modal({ show: 'true' });

        $('#addCurrencyID').val('0');

        $('#addModalRateHeader').attr('hidden', false);
        $('#editModalRateHeader').attr('hidden', true);

        $('#uniqueCurrencyRateName').attr('hidden', true);
        $('#modalAddSubmitButton').attr('disabled', true);
    }

    function RenameCurrency() {

        $('#addCurrencyID').val(selectedCurrencyRateID);
        $.ajax({
            type: "POST",
            url: '/CurrencyRates/GetCurrencyRateName/' + selectedCurrencyRateID,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addCurrencyName').val(response.name);
                    $('#addCurrencyModal').modal({ show: 'true' });

                    $('#addModalRateHeader').attr('hidden', true);
                    $('#editModalRateHeader').attr('hidden', false);

                    $('#uniqueCurrencyRateName').attr('hidden', true);
                    $('#modalAddSubmitButton').attr('disabled', true);
                }
            },
            failure: function (response) {
                alert(response.responseText);
            },
            error: function (response) {
                alert(response.responseText);
            }
        });
    }

    function EditCurrency() {
        $('#CurrencyContent').load("/CurrencyRates/Edit/" + selectedCurrencyRateID);
    }

    function DeleteCurrency() {
        $('#deleteCurrencyRateID').val(selectedCurrencyRateID);
        $('#confirmDelete').modal({ show: 'true' });
    }

    function initDateTimePicker() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerDay').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
        $('#datetimepickerTo').datetimepicker(options);
    }

    function UpdateCurrencyType() {
        let val = $('#CurrencyUpdateType').val() * 1;

        switch (val) {
            case 0:
            default:
                $('#ActionType1Section').slideUp('fast');
                $('#ActionType2LeftSection').slideUp('fast');
                $('#ActionType2RightSection').slideUp('fast');
                break;
            case 1:
                $('#datetimepickerDay').data("DateTimePicker").setDate(new Date());
                $('#ActionType1Section').slideDown('fast');
                $('#ActionType2LeftSection').slideUp('fast');
                $('#ActionType2RightSection').slideUp('fast');
                break;
            case 2:
                var d = new Date();
                $('#datetimepickerTo').data("DateTimePicker").setDate(d);
                d.setMonth(d.getMonth() - 1);
                $('#datetimepickerFrom').data("DateTimePicker").setDate(d);
                $('#ActionType1Section').slideUp('fast');
                $('#ActionType2LeftSection').slideDown('fast');
                $('#ActionType2RightSection').slideDown('fast');
                break;
        }
    }

    $('#CurrencyContent').load("/CurrencyRates/GetCurrencyRates", function () {
        UpdateTableUI('');
        $('#tbSearch').on('input', function (e) { UpdateTableUI($('#tbSearch').val()); });

        $('#btn-tools').on('click', 'button[data-name="Add"]', AddCurrency);

        $('#btn-tools').on('click', 'button[data-name="Rename"]', RenameCurrency);

        $('#btn-tools').on('click', 'button[data-name="Edit"]', EditCurrency);

        $('#btn-tools').on('click', 'button[data-name="Delete"]', DeleteCurrency);

        $('#btn-tools').on('click', 'button[data-name="SetMain"]', function () {
            $.ajax({
                type: "POST",
                url: '/CurrencyRates/SetupMain/' + selectedCurrencyRateID,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTableUI($('#tbSearch').val());
                    }
                }
            });
        });

        //setup before functions
        var typingTimer;                //timer identifier
        var doneTypingInterval = 500;  //time in ms, 0.75 second for example
        var $inputCurr = $('#addCurrencyName');

        //on keyup, start the countdown
        $inputCurr.on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: '/CurrencyRates/IsUniqueCurrencyRateName/?name=' + $('#addCurrencyName').val(),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            if (response.IsUnique === true) {
                                $('#uniqueCurrencyRateName').slideUp('fast');
                                $('#modalAddSubmitButton').prop('disabled', false);
                            }
                            else {
                                $('#uniqueCurrencyRateName').slideDown('fast');
                                $('#modalAddSubmitButton').prop('disabled', true);
                            }

                            
                        }
                    }
                });
            }, doneTypingInterval);
        });
        //on keydown, clear the countdown 
        $inputCurr.on('keydown', function () { clearTimeout(typingTimer); });

        //show modal tp update currency
        $('#btnUpdateRate').on('click', () => {
            $('#CurrencyUpdateType').val('0');
            UpdateCurrencyType();
            $('#UpdateCurrencyModal').modal('show');
        });

        //change the currency type
        $('#CurrencyUpdateType').change(UpdateCurrencyType);

        //try to get currencies
        $('#btnGetCurrency').on('click', () => {
            ShowSpinner(true);

            var formData = new FormData();

            formData.append('day', $('#datetimepickerDay').data('date'));
            formData.append('from', $('#datetimepickerFrom').data('date'));
            formData.append('to', $('#datetimepickerTo').data('date'));
            formData.append('type', $('#CurrencyUpdateType').val());

            $.ajax({
                type: "POST",
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/CurrencyRates/UpdateRate/' + selectedCurrencyRateID,
                success: function (response) {
                    ShowSpinner(false);
                    if (response.success === true) {
                        $('#CurrencyUpdateSuccessModal').modal('show');
                        UpdateTableUI($('#tbSearch').val());
                    }
                    else {
                        $('#CurrencyUpdateErrorModal').modal('show');
                    }
                }
            });
        });

        initDateTimePicker();
    });
});