$(document).ready(function () {
    var autcodeWidth = $("#account-authcode");
    var contractIdWidth = $("#contract-id");


    
    $('#abonent-type-details').width(autcodeWidth.width());
    $('#abonent-contract-date').width(contractIdWidth.width());

    /////////////////// Collapse panel ///////////////////

    $('.panel-heading span.clickable').on("click", function (e) {
        if ($(this).hasClass('panel-collapsed')) {
            // expand the panel
            $(this).parents('.panel').find('.panel-body').slideDown();
            $(this).removeClass('panel-collapsed');
            $(this).find('i').removeClass('glyphicon-chevron-down').addClass('glyphicon-chevron-up');
        }
        else {
            // collapse the panel
            $(this).parents('.panel').find('.panel-body').slideUp();
            $(this).addClass('panel-collapsed');
            $(this).find('i').removeClass('glyphicon-chevron-up').addClass('glyphicon-chevron-down');
        }
    });

    $('#create-abonent-service-account').click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            var id = $('#account-id').text();
            CreateAbonentService(id, data, "manual");
        });
    });

    $('.edit-abonent-service-account').click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            var id = $('#account-id').text();
            var row = document.getElementById('month-details').rows[editAbonentServiceRowIndex];

            if (hasClassJS(row, 'text-green')) {
                $('#create-abonent-payment').addClass('edit');
                $('#create-abonent-payment').click();
            }
            else {
                var serviceId = row.cells[0].innerHTML;
                EditAbonentService(id, data, "manual", serviceId);
            }
        });
    });

    function hasClassJS(element, className) {
        return element.className && new RegExp("(^|\\s)" + className + "(\\s|$)").test(element.className);
    }

    $('#month-details tbody').on('click', 'tr', function () {
        var table = $('#month-details').DataTable();
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        }
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var index = table.row(this).index();
        }
    });

    var isChangeRowIndex = true;
    var editAbonentServiceRowIndex = 0;

    $('#month-details tbody').
      on('mouseover', 'tr', function () {
          if (isChangeRowIndex) {
              editAbonentServiceRowIndex = $(this).index() + 1;
          }
      });

    ////////Context Menu
    $(function () {

        $.contextMenu({
            selector: '#month-details',
            callback: function (key, options) {
                if ($('#is-open-context-menu').hasClass('true')) {
                    switch (key) {
                        case "addService":
                            $('#create-abonent-service-account').click();
                            break;
                        case "addPayment":
                            $('#create-abonent-payment').click();
                            break;
                        case "editService":
                            isChangeRowIndex = false;
                            $('#edit-abonent-service-account').click();
                            break;
                        case "removeService":
                            var id = document.getElementById('month-details').rows[editAbonentServiceRowIndex].cells[0].innerHTML;
                            RemoveAccount(id);
                            break;
                    }
                }

            },
            items: {
                "addService": { name: "Add custom service" },
                "addPayment": { name: "Add payment" },
                "editService": { name: "Edit" },
                "removeService": { name: "Remove" }
            }
        });

        $.contextMenu({
            selector: '#summary-charges',
            callback: function (key, options) {
                if ($('#is-open-context-menu').hasClass('true')) {
                    switch (key) {
                        case "addService":
                            $('#create-abonent-service-account').click();
                            break;
                        case "addPayment":
                            $('#create-abonent-payment').click();
                            break;
                    }
                }

            },
            items: {
                "addService": { name: "Add custom service" },
                "addPayment": { name: "Add payment" }
            }
        });

    });

    function RemoveAccount(id) {
        $.ajax({
            type: "DELETE",
            url: "/api/account/" + id,
            contentType: "application/json",
            dataType: "json"
        });
        RefreshAbonentInfo();
    }

    $('#refresh-tables-account').click(function () {
        RefreshAbonentInfo();
    });

    $('#add-month-account').click(function () {
        var currentYear = $('#years-account').val();
        var currentMonth = $('#monthes-account').val();

        if (parseInt(currentMonth) === 12) {
            $('#monthes-account [value=' + 1 + ']').prop('selected', true);
            $('#years-account [value=' + (parseInt(currentYear) + 1) + ']').prop('selected', true);
        }
        else {
            $('#monthes-account [value=' + (parseInt(currentMonth) + 1) + ']').prop('selected', true);
        }
        RefreshAbonentInfo();
    });

    $('#subtract-month-account').click(function () {
        var currentYear = $('#years-account').val();
        var currentMonth = $('#monthes-account').val();

        if (parseInt(currentMonth) === 1) {
            $('#monthes-account [value=' + 12 + ']').prop('selected', true);
            $('#years-account [value=' + (parseInt(currentYear) - 1) + ']').prop('selected', true);
        }
        else {
            $('#monthes-account [value=' + (parseInt(currentMonth) - 1) + ']').prop('selected', true);
        }
        RefreshAbonentInfo();
    });

    function RefreshAbonentInfo() {
        var id = $('#account-id-details').val();

        if (id === '0' || id === undefined || id === '') {
            return;
        }

        var selectedYear = $('#years-account').val();
        var selectedMonth = $('#monthes-account').val();

        var summaryCharges = $('#summary-charges').DataTable();
        summaryCharges.ajax.url('/api/account/abonents/' + id + '/summarycharges/' + selectedYear + '/' + selectedMonth);
        summaryCharges.ajax.reload();

        var monthDetails = $('#month-details').DataTable();
        monthDetails.ajax.url('/api/account/abonents/' + id + '/monthdetails/' + selectedYear + '/' + selectedMonth);
        monthDetails.ajax.reload();

        var callsTraficUsed = $('#calls-trafic-used').DataTable();
        callsTraficUsed.ajax.url('/api/account/abonents/' + id + '/callstrafic/' + selectedYear + '/' + selectedMonth);
        callsTraficUsed.ajax.reload();

        $.getJSON('/api/abonents/' + id + '/details/' + selectedYear + '/' + selectedMonth, function (data) {
            $('#account-id').html(data.AccountId);
            $('#active-from').html(data.ActiveFrom);
            $('#active-to').html(data.ActiveTo);
            $('#extensions').html(data.Extensions);
            $('#month-charges').html(data.MonthCharges);
            $('#month-payments').html(data.MonthPayments);
            $('#name').html(data.Name);
            $('#start-month-debt').html(data.StartMonthDebt);
            $('#tarif-plan').html(data.TarifPlan);
            $('#total-debt').html(data.TotalDebt);
            $('#bref-info').html('(' + data.AccountId + ' - ' + data.Name + ')');
        });
    }

    $('#add-report').click(function () {
        var year = $('#years-account').val();
        var month = $('#monthes-account').val();
        var abonentId = $('#account-id').text();
        window.location.href = '/Reporting/Index?year=' + year + '&month=' + month + '&abonentId=' + abonentId;
    });

    /////////// Edit payment
    $(".dialogEditPayment").click(function (e) {
        e.preventDefault();
        if (!$(this).hasClass("edit")) {
            $.get(this.href, function (data) {
                $('#dialogEditPayment').html(data);
                $('#modEditPayment').modal('show');
                $('#type-operation').text('create');
            });
        }
        else if (!$(this).hasClass("break-load-page")) {
            $.get(this.href, function (data) {
                $('#dialogEditPayment').html(data);
                $('#modEditPayment').modal('show');
                var id = document.getElementById('month-details').rows[editAbonentServiceRowIndex].cells[0].innerHTML;

                $.getJSON('/api/account/payment/' + id, function (d) {
                    $('#date-edit-payment').val(d.Payment.RecDate);
                    $('#payment-edit-payment').val(d.Payment.Payment);
                    $('#description-edit-payment').val(d.Payment.Description);
                    $('#bank-edit-payment').val(d.Payment.BankAuthority);
                    $('#payment-type-edit-payment').val(d.Payment.PaymentType);
                    $('#id-payment').val(d.Payment.ID);
                });
            });
        }
        isChangeRowIndex = true;
    });


    /////////////////////////////////////////////////////////////////////////
    //////////////////// Initialization /////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////

    (function SetVirtualAbonent() {
        var abonentId = $('#account-id-details').val();

        $.getJSON('/api/abonents/' + abonentId, function (data) {
            if (data.Abonent.PersonalCode === "~") {
                console.log("IsVirtualAbonent");
                $("#checkVirtualAbonent").attr("checked", true);
            }
            else {
                console.log("IsRealAbonent");
                $("#checkVirtualAbonent").attr("checked", false);
            }
        });
    })();

    var editButtonState = $("#abonent-credits").find('option:selected');
    if (editButtonState == null || editButtonState.length == 0) {
        $("#edit-category-credit").addClass("disabled");
    }
    else {
        $("#edit-category-credit").removeClass("disabled");
    }

    //$("#active-from-details").datepicker({ changeMonth: !0, changeYear: !0, showButtonPanel: !0, dateFormat: "yy-mm-dd" });
    //$("#active-to-details").datepicker({ changeMonth: !0, changeYear: !0, showButtonPanel: !0, dateFormat: "yy-mm-dd" });
    //$("#contract-date-details").datepicker({ changeMonth: !0, changeYear: !0, showButtonPanel: !0, dateFormat: "yy-mm-dd" });

    //SetDateWithCheckbox($('#active-from-details'), 'checkActiveFrom');
    //SetDateWithCheckbox($('#active-to-details'), 'checkActiveTo');
    //SetDateWithCheckbox($('#contract-date-details'), 'checkContractDate');
    
    function ParseDateStr(str) {
        var parts = str.split('.');
        if (parts.length < 3)
            parts = str.split('/');
         
        return parts[2] + '-' + parts[0] + '-' + parts[1];
    }

    function SetDateWithCheckbox(inputDate$, checkBoxId) {
        var value = ParseDateStr(inputDate$.val());
        if (undefined != value) {
            var date = new Date(value);

            var minDate = $.tariscope.dateTime.minDate();
            var maxDate = $.tariscope.dateTime.maxDate();
            if (date.getTime() == minDate.getTime() || date.getTime() == maxDate.getTime() || !date) {
                inputDate$.attr("checked", false).prop("disabled", true).addClass("disabled").val($.tariscope.dateTime.getCurrentDate());
            }
            else {
                $('#' + checkBoxId).attr("checked", true);
                inputDate$.prop("disabled", false).removeClass("disabled").val($.tariscope.dateTime.ConvertToDate(value));
            }
        }
    }

    $('#checkContractDate').change(function () {
        if ($(this).is(":checked")) {
            $('#contract-date-details').prop('disabled', false).removeClass("disabled");
        }
        else {
            $('#contract-date-details').prop('disabled', true).addClass("disabled");
        }
    });

    $('#checkActiveTo').change(function () {
        if ($(this).is(":checked")) {
            $('#active-to-details').prop('disabled', false).removeClass("disabled");
        }
        else {
            $('#active-to-details').prop('disabled', true).addClass("disabled");
        }
    });

    $('#checkActiveFrom').change(function () {
        if ($(this).is(":checked")) {
            $('#active-from-details').prop('disabled', false).removeClass("disabled");
        }
        else {
            $('#active-from-details').prop('disabled', true).addClass("disabled");
        }
    });

    $('#services-tbl').on('draw.dt', function () {
        $("table#services-tbl tr td:first-child").addClass("hidden");
        $("table#services-tbl tr th:first-child").addClass("hidden");
    });

    /////////// Tab details

    $('#refresh-category-credit').click(function () {
        var abonentCredits = $('#abonent-credits').DataTable();
        abonentCredits.ajax.reload();
        $("#remove-category-credit").addClass("break-load-page");
        $("#edit-category-credit").addClass("break-load-page");
    });

    $('#abonent-credits').on('draw.dt', function () {
        $("table#abonent-credits tr td:first-child").addClass("hidden");
        $("table#abonent-credits tr th:first-child").addClass("hidden");
    });

    $('#abonent-credits tbody').on('click', 'tr', function () {
        if ($("#edit-category-credit").hasClass("disabled")) {
            $("#edit-category-credit").removeClass("disabled");
        }

        var table = $('#abonent-credits').DataTable();
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $("#remove-category-credit").addClass("break-load-page");
            $("#edit-category-credit").addClass("break-load-page");
        }
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var index = table.row(this).index();
            $("#remove-category-credit").removeClass("break-load-page");
            $("#edit-category-credit").removeClass("break-load-page");
        }
    });

    $("#remove-category-credit").click(function () {
        $.get("/Subscriber/RemoveCategoryCredit", function (data) {
            $('#dialogRemoveCategoryCredit').html(data);
            $('#modRemoveCategoryCredit').modal('show');
        });
    });

    /////////// Tab Service

    $('#services-tbl tbody').on('click', 'tr', function () {
        var table = $('#services-tbl').DataTable();
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $('#remove-row-service').addClass('break-load-page');
            $('#edit-row-service').addClass('break-load-page');
            $("#remove-row-service").addClass("disabled");
            $("#edit-row-service").addClass("disabled");
        }
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var index = table.row(this).index();

            $('#remove-row-service').removeClass('break-load-page');
            $('#edit-row-service').removeClass('break-load-page');
            $("#remove-row-service").removeClass("disabled");
            $("#edit-row-service").removeClass("disabled");
        }
    });


    $("#show-all-services").click(function () {
        var abonenetid = $('#account-id-details').val();

        var services = $('#services-tbl').DataTable();
        services.ajax.url('/api/abonentservices/abonents/' + abonenetid + '/table');
        services.ajax.reload();
    });

    $("#show-active-services").click(function () {
        var abonenetid = $('#account-id-details').val();

        var services = $('#services-tbl').DataTable();
        services.ajax.url('/api/abonentservices/abonents/' + abonenetid + '/active/table');
        services.ajax.reload();
    });

    $("#remove-row-service").click(function () {
        $.get("/Subscriber/RemoveService", function (data) {
            $('#dialogRemoveService').html(data);
            $('#modRemoveService').modal('show');
        });
    });

    /////////// Tab account
    $('#account-tab').click(function () {
        var id = $('#account-id-details').val();
        var services = $('#account-history').DataTable();
        services.ajax.url('/api/account/abonents/' + id + '/history/table');
        services.ajax.reload();
        $.getJSON('/api/account/abonents/' + id + '/balance', function (data) {
            $('#balance-details').val(data.Balance);
        });
        $.getJSON('/api/account/abonents/' + id + '/lastpaymentdate', function (data) {
            $('#last-payment-date-details').val(data.LastPaymentDate);
        });
    });

    $('#account-history').on('draw.dt', function () {
        $("table#account-history tr td:first-child").addClass("hidden");
        $("table#account-history tr th:first-child").addClass("hidden");
    });

    /////////// Tab damages
    $('#damages-tbl').on('draw.dt', function () {
        $("table#account-history tr td:first-child").addClass("hidden");
        $("table#account-history tr th:first-child").addClass("hidden");
    });

    $('#damages-tbl tbody').on('click', 'tr', function () {
        var table = $('#damages-tbl').DataTable();
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $('#edit-row-damage').addClass('break-load-page');
        }
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var index = table.row(this).index();
            $('#edit-row-damage').removeClass('break-load-page');
        }
    });

    /////////// Tab documents
    $('#documents-tbl').on('draw.dt', function () {
        $("table#documents-tbl tr td:first-child").addClass("hidden");
        $("table#documents-tbl tr th:first-child").addClass("hidden");
    });

    $('#documents-tbl tbody').on('click', 'tr', function () {
        var table = $('#documents-tbl').DataTable();
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $('#edit-row-documents').addClass('break-load-page');
        }
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var index = table.row(this).index();
            $('#edit-row-documents').removeClass('break-load-page');
        }
    });

    $('#download-document').click(function () {
        var rowIndex = $('#documents-tbl .selected').index();
        if (rowIndex < 0)
            return;
        var row = document.getElementById('documents-tbl').rows[rowIndex + 1];
        var id = row.cells[0].innerHTML;

        var url = "/api/abonentdocuments/" + id + "/download";

        //window.location.href = url;
        window.open(url, "_blank");
    });

    $("#remove-row-documents").click(function () {
        var rowIndex = $('#documents-tbl .selected').index();
        if (rowIndex < 0)
            return;

        $.get("/Subscriber/RemoveDocument", function (data) {
            $('#dialogRemoveDocument').html(data);
            $('#modRemoveDocument').modal('show');
        });
    });

    $("#remove-row-damage").click(function () {
        var rowIndex = $('#documents-tbl .selected').index();
        if (rowIndex < 0)
            return;
        $.get("/Subscriber/RemoveDamage", function (data) {
            $('#dialogRemoveDamage').html(data);
            $('#modRemoveDamage').modal('show');
        });
    });

    /////////// LogIn modal

    $(".dialogLogIn").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogContent').html(data);
            $('#modDialog').modal('show');
        });
    });

    /////////// Change delivery type

    $("#delivery-type-details").change(function () {
        var deliveryType = $('#delivery-type-details option:selected').val();
        var abonentNameFields = {};

        var abonentId = $('#account-id-details').val();

        $.get("/api/abonents/" + abonentId + "/abonenttype", function (accountType) {
            abonentNameFields['DeliveryType'] = deliveryType;

            $.ajax({
                type: "PUT",
                url: "/api/abonents/" + abonentId,
                contentType: "application/json",
                data: JSON.stringify(abonentNameFields),
                dataType: "json"
            });
        });

        $('#modSubscriberName').modal('hide');
    });

    /////////// Name modal

    $(".dialogSubscriberName").click(function (e) {
        var abonentId = $('#account-id-details').val();

        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogSubscriberName').html(data);
            $('#modSubscriberName').modal('show');

            $.get("/api/abonents/" + abonentId + "/abonenttype", function (accountType) {
                if (accountType == 1) {
                    $('#firmName').prop("disabled", false);
                    $('#firstName').prop("disabled", true);
                    $('#lastName').prop("disabled", true);
                    $('#secondName').prop("disabled", true);
                }
                else {
                    $('#firmName').prop("disabled", true);
                    $('#firtName').prop("disabled", false);
                    $('#lastName').prop("disabled", false);
                    $('#secondName').prop("disabled", false);
                }

                $.getJSON('/api/abonents/' + abonentId, function (data) {
                    console.log('Name data');
                    console.log(data);
                    if (accountType == 1) {
                        if (data.Abonent.AbonentName == "New abonent")
                            $('#firmName').val('Company name');
                        else {
                            $('#firmName').val(data.Abonent.FullName);
                        }
                        $('#fullName').val(data.Abonent.LastName);
                    }
                    else {
                        $('#lastName').val(data.Abonent.LastName);
                        $('#firstName').val(data.Abonent.FirstName);
                        $('#secondName').val(data.Abonent.SecondName);
                        $('#fullName').val(data.Abonent.LastName + " " + data.Abonent.FirstName + " " + data.Abonent.SecondName);
                    }
                });
            });
        });
    });

    $(".dialogSubscriberGroup").click(function (e) {
        e.preventDefault();
  
        $.get(this.href, function (data) {
            $('#dialogSubscriberGroup').html(data);
            $('#modSubscriberGroup').modal('show');
        });
    });

    $('#abonent-type-details').change(function () {
        var abonentId = $('#account-id-details').val();

        var accountType = $('#abonent-type-details option:selected').val();
        var abonentNameFields = {};
        abonentNameFields['AbonentType'] = accountType;
       // firmName
        $.getJSON('/api/abonents/' + abonentId, function (data) {
            if (accountType == 1) {
                abonentNameFields['LastName'] = data.Abonent.LastName;
                abonentNameFields['FullName'] = data.Abonent.LastName;
            }

            $.ajax({
                type: "PUT",
                url: "/api/abonents/" + abonentId + "/",
                contentType: "application/json",
                data: JSON.stringify(abonentNameFields)
            });
        });
    });

    /////////// Dns modal

    $(".dialogDns").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogDns').html(data);
            $('#modDns').modal('show');

            var id = $('#account-id-details').val();
            var dns = $('#dns').DataTable();
            dns.ajax.url('/api/dns/abonents/' + id + '/inactive/table');
            dns.ajax.reload();
        });
    });

    /////////// Auxiliary identifiers

    $(".dialogAuxiliaryIdentifiers").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogAuxiliaryIdentifiers').html(data);
            $('#modAuxiliaryIdentifiers').modal('show');

            var id = $('#account-id-details').val();
            var auxIds = $('#auxilary-identifiers').DataTable();
            auxIds.ajax.url('/api/abonents/' + id + '/auxilaryidentifiers');
            auxIds.ajax.reload();
        });
    });


    /////////// Planes

    $(".dialogPlanes").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogPlanes').html(data);
            $('#modPlanes').modal('show');

            var id = $('#account-id-details').val();
            var pl = $('#tariff-plan').DataTable();
            pl.ajax.url('/api/abonents/' + id + '/planes');
            pl.ajax.reload();
        });
    });


    /////////// Address

    $(".dialogAddress").click(function (e) {
        if (!$(this).hasClass("address2")) {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogAddress').html(data);
                $('#modAddress').modal('show');

                var id = $('#account-id-details').val();

                $.getJSON('/api/abonents/' + id, function (data) {
                    $('#city-address').val(data.Abonent.City);
                    $('#zipe-code-address').val(data.Abonent.ZipCode);
                    $('#area-address').val(data.Abonent.Area);
                    $('#street-address').val(data.Abonent.Street);
                    $('#building-address').val(data.Abonent.Building);
                    $('#house-address').val(data.Abonent.House);
                    $('#floor-address').val(data.Abonent.FloorNumber);
                    $('#office-address').val(data.Abonent.Flat);
                });

            });
        }
        else {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogAddress').html(data);
                $('#modAddress').modal('show');

                var id = $('#account-id-details').val();

                $.getJSON('/api/abonents/' + id, function (data) {
                    $('#type-address').html("address2");
                    $('#city-address').val(data.Abonent.City2);
                    $('#zipe-code-address').val(data.Abonent.ZipCode2);
                    $('#area-address').val(data.Abonent.Area2);
                    $('#street-address').val(data.Abonent.Street2);
                    $('#building-address').val(data.Abonent.Building2);
                    $('#house-address').val(data.Abonent.House2);
                    $('#floor-address').val(data.Abonent.FloorNumber2);
                    $('#office-address').val(data.Abonent.Flat2);
                });
            });
        }

    });

    /////////// Password

    $(".dialogWebCabinet").click(function (e) {
        var abonentId = $('#account-id-details').val();

        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogWebCabinet').html(data);
            $('#modWebCabinet').modal('show');

            $.getJSON('/api/abonents/' + abonentId, function (data) {
                $('#webcabinet-email').val(data.Abonent.EMail);
                $('#webcabinet-password').val(data.Abonent.Password);
                $('#webcabinet-confirm-password').val(data.Abonent.Password);
            });
        });
    });

    /////////// Contact phones

    $(".dialogContactPhones").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogContactPhones').html(data);
            $('#modContactPhones').modal('show');
            var id = $('#account-id-details').val();
            var contactPhones = $('#contact-phones').DataTable();
            contactPhones.ajax.url('/api/abonents/' + id + '/contacts');
            contactPhones.ajax.reload();
        });
    });

    /////////// Edit Service
    function CreateAbonentService(id, data, typeService) {
        var urlServices = "";
        $('#dialogEditAbonentService').html(data);
        $('#modEditAbonentService').modal('show');

        if (typeService === "manual") {

            $('#service-id').addClass("manual");
            urlServices = "/api/services/table/manual";
        }
        else if (typeService === "periodic") {
            $('.manual-services').hide();
            $('#service-id').addClass("periodic");
            urlServices = "/api/services/table/periodic";
        }


        $('#abonent-id-edit-services').val(id);
        $('#type-operation').html("create");
        $.getJSON('/api/dns/abonents/' + id, function (d) {
            var selectDns = $("#dns-edit-service");
            d.Dns.forEach(function (item) {
                selectDns.append('<option value="' + item.ID + '">' + item.DN + '</option>');
            });
        });

        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth() + 1;
        var yyyy = today.getFullYear();
        $("#active-from-edit-service").val(yyyy + "-" + mm + "-" + dd).prop("disabled", false).removeClass("disabled");
        $("#active-to-edit-service").val(yyyy + "-" + mm + "-" + dd).prop("disabled", true);
        $("#charge-date-edit-service").val(yyyy + "-" + mm + "-" + "01");
        $("#check-active-from-edit-service").attr('checked', true);

        var services = $('#service-edit-tbl').DataTable();
        services.ajax.url(urlServices);
        services.ajax.reload();
    }

    function EditAbonentService(id, data, typeService, serviceId) {
        var urlServices = "";
        $('#dialogEditAbonentService').html(data);
        $('#modEditAbonentService').modal('show');

        var minDate = new Date("01/01/1900").getTime();
        var maxDate = new Date("01/01/3000").getTime();

        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth() + 1;
        var yyyy = today.getFullYear();

        if (typeService === "manual") {
            $('.periodic-services').hide();
            $('#service-id').addClass("manual");
            urlServices = "/api/services/table/all";
            urlAbonentServices = '/api/account/customservice/' + serviceId + '/';

            $.getJSON(urlAbonentServices, function (servData) {
                $('#amount-edit-service').val(servData.AbonentService.Charge);
                $('#description-edit-service').val(servData.AbonentService.Description);
                $('#service-id').html(servData.AbonentService.ServiceID2);
                $('#abonentservice-id').html(servData.AbonentService.ServiceID);
                $('#charge-date-edit-service').val(servData.AbonentService.RecDate);
                $('#custom-service-id-edit-services').val(servData.AbonentService.ID);

                $.getJSON('/api/dns/abonents/' + id, function (d) {
                    var selectDns = $("#dns-edit-service");

                    d.Dns.forEach(function (item) {
                        if (item.ID == servData.AbonentService.DNID) {
                            selectDns.append('<option value="' + item.ID + '" selected>' + item.DN + '</option>');
                        }
                        else {
                            selectDns.append('<option value="' + item.ID + '">' + item.DN + '</option>');
                        }
                    });
                });

            });

        }
        else if (typeService === "periodic") {
            $('#service-id').addClass("periodic");
            $('.manual-services').hide();
            urlServices = "/api/services/table/periodic";
            urlAbonentServices = '/api/abonentservices/' + serviceId;

            $.getJSON(urlAbonentServices, function (servData) {
                $('#amount-edit-service').val(servData.AbonentService.Amount);
                $('#description-edit-service').val(servData.AbonentService.Description);
                $('#service-id').html(servData.AbonentService.ServiceID);
                $('#abonentservice-id').html(servData.AbonentService.ID);

                let dateString;

                if (servData.AbonentService.FromDate == null) {
                    $("#active-from-edit-service").prop("disabled", true).addClass("disabled").val(yyyy + "-" + mm + "-" + dd);
                }
                else if ($("#active-from-edit-service").val() !== undefined) {
                    dateString = servData.AbonentService.FromDate.replace(/\./g, '/').substring(0, 10);

                    if (new Date(dateString).getTime() == minDate) {
                        $('#check-active-from-edit-service').attr('checked', false);
                        $("#active-from-edit-service").prop("disabled", true).addClass("disabled").val(yyyy + "-" + mm + "-" + dd);
                    }
                    else {
                        $('#check-active-from-edit-service').attr('checked', true);
                        $("#active-from-edit-service").prop("disabled", false).removeClass("disabled").val(dateString);
                    }
                }

                if (servData.AbonentService.ToDate == null) {
                    $("#active-to-edit-service").prop("disabled", true).addClass("disabled").val(yyyy + "-" + mm + "-" + dd);
                }
                else if ($("#active-to-edit-service").val() !== undefined) {
                    dateString = servData.AbonentService.ToDate.replace(/\./g, '/').substring(0, 10);

                    if (new Date(dateString).getTime() == minDate) {
                        $('#check-active-to-edit-service').attr('checked', false);
                        $("#active-to-edit-service").prop("disabled", true).addClass("disabled").val(yyyy + "-" + mm + "-" + dd);
                    }
                    else {
                        $('#check-active-to-edit-service').attr('checked', true);
                        $("#active-to-edit-service").prop("disabled", false).removeClass("disabled").val(dateString);
                    }
                }

                $.getJSON('/api/dns/abonents/' + id, function (d) {
                    var selectDns = $("#dns-edit-service");

                    d.Dns.forEach(function (item) {
                        if (item.ID == servData.AbonentService.DNID) {
                            selectDns.append('<option value="' + item.ID + '" selected>' + item.DN + '</option>');
                        }
                        else {
                            selectDns.append('<option value="' + item.ID + '">' + item.DN + '</option>');
                        }
                    });
                });
            });
        }

        var services = $('#service-edit-tbl').DataTable();
        services.ajax.url(urlServices);
        services.ajax.reload();

        isChangeRowIndex = true;
    }

    $(".dialogEditAbonentService").click(function (e) {
        var id = $('#account-id-details').val();
        e.preventDefault();

        if ($(this).hasClass("create-service")) {
            $.get(this.href, function (data) {
                CreateAbonentService(id, data, "periodic");
            });
        }
        else if (!$(this).hasClass("break-load-page")) {
            $.get(this.href, function (data) {
                var rowIndex = $('#services-tbl .selected').index();
                var row = document.getElementById('services-tbl').rows[rowIndex + 1];
                serviceId = row.cells[0].innerHTML;
                EditAbonentService(id, data, "periodic", serviceId);
            });
        }
    });

    /////////// Category credit

    $(".dialogCategoryCredit").click(function (e) {
        if ($(this).hasClass("break-load-page")) {
            e.preventDefault();
        }
        else if (!$(this).hasClass("edit-category-credit")) {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogCategoryCredit').html(data);
                $('#modCategoryCredit').modal('show');
                $('#type-operation').addClass('create-abonent-credit');
                $('#status-category-credit').val('Not restricted');
            });
        }
        else {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogCategoryCredit').html(data);
                $('#modCategoryCredit').modal('show');

                var table = $('#abonent-credits').DataTable();
                var abonentCreditId = table.rows('.selected').data()[0].ID;

                $.getJSON('/api/abonentcredits/' + abonentCreditId, function (d) {
                    $('#abonent-credit-id').text(d.AbonentCredit.ID).attr("categoryId", d.AbonentCredit.CategoryID);
                    $('#category-category-credit [value=' + d.AbonentCredit.CategoryID + ']').attr("selected", "selected");
                    $('#restrict-type-category-credit [value=' + d.AbonentCredit.RestrictType + ']').attr("selected", "selected");
                    $('#restrict-class-category-credit').val(d.AbonentCredit.RestrictClass);
                    $('#credit-category-credit').val(d.AbonentCredit.Credit);
                    $('#charge-category-credit').val(d.AbonentCredit.Debit);
                    $('#status-category-credit').val($('#restrict-status-details option[value="' + d.AbonentCredit.RestrictStatus + '"]').html());
                });
            });
        }

    });

    /////////// Edit damage
    $(".dialogEditDamage").click(function (e) {
        if (!$(this).hasClass("edit-damage")) {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogEditDamage').html(data);
                $('#modEditDamage').modal('show');
                $('#type-operation').text('create');
            });
        }
        else if ($(this).hasClass("break-load-page")) {
            e.preventDefault();
        }
        else {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogEditDamage').html(data);
                $('#modEditDamage').modal('show');

                $('#type-operation').text('edit');

                var rowIndex = $('#damages-tbl .selected').index();
                var id = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[0].innerText;
                var pbxid = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[2].innerText;

                var extension = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[3].innerText;
                var options = $('#dns-edit-damages option');

                for (var i = 0; i < options.length; i++) {
                    if (options[i].innerText == extension) {
                        options[i].selected = true;
                    }
                }

                var from = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[5].innerText;
                var to = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[6].innerText;
                var description = document.getElementById('damages-tbl').rows[rowIndex + 1].cells[7].innerText;

                $('#id-damage').text(id);
                $('#pbxid').text(pbxid);
                $('#date-from-edit-damages').val(from);
                $('#date-to-edit-damages').val(to);
                $('#dns-edit-damages').attr("disabled", "disabled");
                $('#description-edit-damages').text(description);
            });
        }
    });

    /////////// Edit abonent documents
    $(".dialogEditAbonentDocuments").click(function (e) {
        if (!$(this).hasClass("edit-document")) {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogEditAbonentDocuments').html(data);
                $('#modEditAbonentDocuments').modal('show');
                $('#type-operation').text('create');
            });
        }
        else if ($(this).hasClass("break-load-page")) {
            e.preventDefault();
        }
        else {
            e.preventDefault();
            $.get(this.href, function (data) {
                $('#dialogEditAbonentDocuments').html(data);
                $('#modEditAbonentDocuments').modal('show');

                $('#type-operation').text('edit');

                var rowIndex = $('#documents-tbl .selected').index();
                var row = document.getElementById('documents-tbl').rows[rowIndex + 1];
                var id = row.cells[0].innerHTML;
                $('#document-id').text(id);
                $('#file-name-edit-document').val(row.cells[1].innerHTML);
                $('#files').attr("disabled", "disabled");

                $.getJSON('/api/abonentdocuments/' + id, function (d) {
                    $('#date-edit-document').val(d.Document.CreateDate);
                    $('#document-type-edit-document [value=' + d.Document.DocumentType + ']').attr("selected", "selected");
                    $('#number-edit-document').val(d.Document.Number);
                    $('#attributes-edit-document').val(d.Document.Attributes);
                    $('#description-edit-document').val(d.Document.Description);
                });

            });
        }
    });
});