﻿$(document).ready(function () {
    var selectedUser = null;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Account/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Account/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (selectedUser === null) {
            $("#btnOpenProfile").attr("disabled", true);
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnBlock").attr("disabled", true);
            $("#btnResetPass").attr("disabled", true);
        }
        else {
            $("#btnOpenProfile").attr("disabled", false);
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnBlock").attr("disabled", false);
            $("#btnResetPass").attr("disabled", false);
        }
    }

    function AttachEventsToUsersTable() {
        $('#tariscope-users tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedUser = null;
            }
            else {
                selectedUser = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-users tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });
        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Account/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadUsers();
                    }
                }
            });
        });
    }

    function LoadUsers() {
        selectedUser = null;
        $('#usersTable').load('Users/List', AttachEventsToUsersTable);
    }

    //Go to Create New User
    $('#btnAdd').on('click', function () {
        window.location.href = "/Users/New"
    });

    //Go to Edit selected user
    $('#btnEdit').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/IsNotDefault/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.location.href = "/Users/Edit/?id=" + encodeURIComponent(selectedUser);
                }
                else {
                    $('#cannotEdit').show();
                    $('#cannotBlockS').hide();
                    $('#cannotDelte').hide();

                    $('#cannotDefault').modal('show');
                }
            }
        });
    });

    //Go to user profile
    $('#btnOpenProfile').on('click', function () {
        window.location.href = "/Users/Profile/?id=" + encodeURIComponent(selectedUser);
    });

    //show modal for delete user
    $('#btnDelete').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/IsNotDefault/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#cannotDelete').slideUp();
                    $('#DeleteConfirm').prop('disabled', false);
                    $('#confirmDelete').modal("show");
                }
                else {
                    $('#cannotEdit').hide();
                    $('#cannotBlockS').hide();
                    $('#cannotDelte').show();

                    $('#cannotDefault').modal('show');
                }
            }
        });
    });

    //confirm deleting user
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/Delete/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadUsers();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#cannotDelete').slideDown('fast');
                    $('#DeleteConfirm').prop('disabled', true);
                }
            }
        })
    });

    //show modal for block user
    $('#btnBlock').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/IsNotDefault/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $.ajax({
                        type: "POST",
                        url: '/Users/Status/?id=' + encodeURIComponent(selectedUser),
                        traditional: true,
                        success: function (response) {
                            if (response !== null && response.success === true) {
                                if (response.block) {
                                    $('#BlockConfirm').hide();
                                    $('#UnBlockConfirm').show();
                                    $('#blockMsg').text(response.msg);
                                    $('#UnBlockConfirm').prop('disabled', false);
                                }
                                else {
                                    $('#BlockConfirm').show();
                                    $('#UnBlockConfirm').hide();
                                    $('#blockMsg').text(response.msg);
                                    $('#BlockConfirm').prop('disabled', false);
                                }

                                $('#cannotBlock').slideUp();
                                $('#wasBlock').slideUp();
                                $('#wasUnBlock').slideUp();

                                $('#confirmBlock').modal('show');
                            }
                        }
                    })
                }
                else {
                    $('#cannotEdit').hide();
                    $('#cannotBlockS').show();
                    $('#cannotDelte').hide();

                    $('#cannotDefault').modal('show');
                }
            }
        });
    });

    //confirm block user
    $('#BlockConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/BlockUser/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#wasBlock').slideDown('fast');
                    $('#BlockConfirm').prop('disabled', true);
                    setTimeout(function () {
                        $('#confirmBlock').modal('hide');
                    }, 2000);
                }
                else {
                    $('#cannotBlock').slideDown('fast');
                    $('#BlockConfirm').prop('disabled', true);
                }
            }
        })
    });

    //confirm unblock user
    $('#UnBlockConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/UnBlockUser/?id=' + encodeURIComponent(selectedUser),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#wasUnBlock').slideDown('fast');
                    $('#UnBlockConfirm').prop('disabled', true);
                    setTimeout(function () {
                        $('#confirmBlock').modal('hide');
                    }, 2000);
                }
            }
        })
    });

    //show modal for enter new password for selected user
    $('#btnResetPass').on('click', function () {
        $('#NewPassConfirm').prop('disabled', true);
        $('#pswdCurrr').val('');
        $('#wrongPass').slideUp();
        $('#enterPassModal').modal('show');
    });

    //block button when empty pass
    $('#pswdCurrr').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#NewPassConfirm').prop('disabled', true);
        }
        else {
            $('#NewPassConfirm').prop('disabled', false);
        }
    });

    //confirm new password
    $('#NewPassConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/SetNewPassword/?id=' + encodeURIComponent(selectedUser) + '&password=' + encodeURIComponent($('#pswdCurrr').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#enterPassModal').modal('hide');
                }
                else {
                    $('#wrongPass').slideDown('fast');
                    $('#NewPassConfirm').prop('disabled', true);
                }
            }
        })
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show modal for change login settings
    $('#btnSetLogin').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/GetLoginSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#wrongEmail').slideUp();
                    $('#wrongMinutes').slideUp();
                    $('#wrongAtempts').slideUp();

                    $('#Attempts').val(response.loginAttempts);
                    $('#Minutes').val(response.loginMinutes);
                    $('#AdminEmail').val(response.loginEmail);

                    if (response.loginSend === true) {
                        $('#SendEmailToAdmins').prop('checked', true);
                        $('#AdminEmailGroup').slideDown('fast');
                        $('#SaveLoginSettings').prop('disabled', !(!$('#AdminEmail').val() || !$('#AdminEmail').val().trim()));
                    }
                    else {
                        $('#SendEmailToAdmins').prop('checked', false);
                        $('#AdminEmailGroup').slideUp();
                        $('#SaveLoginSettings').prop('disabled', false);
                    }

                    $('#setLoginModal').modal('show');
                }
            }
        })
    });

    //disable save button when empty email
    $('#AdminEmail').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#wrongEmail').slideDown('fast');
            $('#SaveLoginSettings').prop('disabled', true);
        }
        else {
            $('#wrongEmail').slideUp('fast');
            $('#SaveLoginSettings').prop('disabled', false);
        }
    });

    //disable save button when empty minutes or equals to zero
    $('#Minutes').on('input', function () {
        if (!$(this).val() || !$(this).val().trim() || $(this).val() === "0") {
            $('#wrongMinutes').slideDown('fast');
            $('#SaveLoginSettings').prop('disabled', true);
        }
        else {
            $('#wrongMinutes').slideUp('fast');
            $('#SaveLoginSettings').prop('disabled', false);
        }
    });

    //disable save button when empty attempts or equals to zero
    $('#Attempts').on('input', function () {
        if (!$(this).val() || !$(this).val().trim() || $(this).val() === "0") {
            $('#wrongAtempts').slideDown('fast');
            $('#SaveLoginSettings').prop('disabled', true);
        }
        else {
            $('#wrongAtempts').slideUp('fast');
            $('#SaveLoginSettings').prop('disabled', false);
        }
    });

    //when dont send hide email section
    $('#SendEmailToAdmins').change(function () {
        if ($(this).prop('checked') === true) {
            $('#AdminEmailGroup').slideDown('fast');

            if ((!$('#Attempts').val() || !$('#Attempts').val().trim() || $('#Attempts').val() === "0") ||
                (!$('#Minutes').val() || !$('#Minutes').val().trim() || $('#Minutes').val() === "0") ||
                (!$('#AdminEmail').val() || !$('#AdminEmail').val().trim())) {
                $('#SaveLoginSettings').prop('disabled', true);
            }
            else {
                $('#SaveLoginSettings').prop('disabled', false);
            }
        }
        else {
            $('#AdminEmailGroup').slideUp('fast');

            if ((!$('#Attempts').val() || !$('#Attempts').val().trim() || $('#Attempts').val() === "0") ||
                (!$('#Minutes').val() || !$('#Minutes').val().trim() || $('#Minutes').val() === "0")) {
                $('#SaveLoginSettings').prop('disabled', true);
            }
            else {
                $('#SaveLoginSettings').prop('disabled', false);
            }
        }
    });

    //save login settings
    $('#SaveLoginSettings').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/SaveLoginSettings/?attempts=' +
                $('#Attempts').val() + '&minutest=' +
                $('#Minutes').val() + '&send=' +
                $('#SendEmailToAdmins').prop('checked') + '&email=' +
                encodeURIComponent($('#AdminEmail').val()),
            traditional: true,
            success: function (response) {
                $('#setLoginModal').modal('hide');
            }
        })
    });

    LoadUsers();
});