﻿let selectedSvc = null;
let selectedSvcAuto = false;

function LoadDns() {
    $('#damageDns').empty();
    $('#dnsSource').empty();
    $('#subSelectExtension').empty();

    $.ajax({
        type: "POST",
        url: '/Services/Bundles/GetDNs/' + $('#AbonentID').val(),
        traditional: true,
        success: function (response) {
            if (response !== null && response.success === true) {
                for (key in response.dns) {
                    $('#damageDns').append('<option value="' + key + '">' + response.dns[key] + '</option>');
                    $('#dnsSource').append('<option value="' + key + '">' + response.dns[key] + '</option>');
                    $('#subSelectExtension').append('<option value="' + key + '">' + response.dns[key] + '</option>');
                }
            }
        }
    });
}

function UpdateSvcButtonUI() {
    if (selectedSvc === null) {
        $('#btnPersonalCost-Svc').prop('disabled', true);
        $('#btnEdit-Svc').prop('disabled', true);
        $('#btnDelete-Svc').prop('disabled', true);
    }
    else {
        $('#btnPersonalCost-Svc').prop('disabled', !selectedSvcAuto);
        $('#btnEdit-Svc').prop('disabled', false);
        $('#btnDelete-Svc').prop('disabled', false);
    }
}

function SearchServices() {
    selectedSvc = null;
    UpdateSvcButtonUI();

    var value = $('#tbSearchServices').val().toLowerCase();

    $("#tariscope-abonent-services tr").each(function (index) {
        if (index != 0) {
            $row = $(this);
            var name = $row.find("td[data-name='ServiceName']").text().toLowerCase();
            var dn = $row.find("td[data-name='DNID']").text().toLowerCase();

            if (name.includes(value) || dn.includes(value)) {
                $(this).show();
            }
            else {
                $(this).hide();
            }
        }
    });
}

function OpenServicesForDN(dn) {
    $('#tbSearchServices').val(dn);
    SearchServices();
    $('.tab-pane').removeClass('active');
    $('#3').addClass('active');

    $('#EditAbonentTabs').find('li').removeClass('active');
    $('#EditAbonentTabs').find('a[href="#3"]').parent().addClass('active');
}

$(document).ready(() => {
    let fields = [];
    let fieldsDate = [];
    let saved = false;

    let selectedBundle = null;
    let selectedForChargeBundle = null;

    let selectedDamage = null;

    let selectedDoc = null;
    let selectedDocName = null;

    let selectedSvcCopy = null;
    let selectedPersCost = null;

    function AttachEventsForServices() {
        selectedSvc = null;
        selectedSvcAuto = false;

        $('#tariscope-abonent-services tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedSvc = null;
                selectedSvcAuto = false;
            }
            else {
                selectedSvc = $(this).find('td[data-name="ID"]').text();
                selectedSvcAuto = $(this).data('auto') * 1 !== 1;
                $('#tariscope-abonent-services tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateSvcButtonUI();
        });

        UpdateSvcButtonUI();
    }

    function UpdateDamagesButtonUI() {
        if (selectedDamage === null) {
            $('#btnEdit-dmg').prop('disabled', true);
            $('#btnDelete-dmg').prop('disabled', true);
        }
        else {
            $('#btnEdit-dmg').prop('disabled', false);
            $('#btnDelete-dmg').prop('disabled', false);
        }
    }

    function AttachEventsForDamages() {
        selectedDamage = null;

        $('#tariscope-abonent-damages tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDamage = null;
            }
            else {
                selectedDamage = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-damages tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateDamagesButtonUI();
        });

        UpdateDamagesButtonUI();
    }

    function AttachEventsForDocs() {
        selectedDoc = null;

        $('#tariscope-abonent-docs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDoc = null;
                selectedDocName = null;
            }
            else {
                selectedDoc = $(this).find('td[data-name="ID"]').text();
                selectedDocName = $(this).find('td[data-name="Name"]').text();
                $('#tariscope-abonent-docs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateDocsButtonUI();
        });

        UpdateDocsButtonUI();
    }

    function UpdateDocsButtonUI() {
        if (selectedDoc === null) {
            $('#btnUploadNew-Doc').prop('disabled', true);
            $('#btnEdit-Doc').prop('disabled', true);
            $('#btnDelete-Doc').prop('disabled', true);
            $('#btnDownload').prop('disabled', true);
        }
        else {
            $('#btnUploadNew-Doc').prop('disabled', false);
            $('#btnEdit-Doc').prop('disabled', false);
            $('#btnDelete-Doc').prop('disabled', false);
            $('#btnDownload').prop('disabled', false);
        }
    }

    function LoadDocuments() {
        $('#docsTable').load('/Subscribers/GetDocuments/' + $('#AbonentID').val(), AttachEventsForDocs);
    }

    function LoadServices() {

        $('#servicesTable').load('/Subscribers/Services/' + $('#AbonentID').val(), AttachEventsForServices);
    }

    function LoadDamages() {
        $('#dmgTable').load('/Subscribers/Damages/' + $('#AbonentID').val(), AttachEventsForDamages);
    }

    function LoadBill() {
        $('#billTable').load('/Subscribers/Bill/' + $('#AbonentID').val());
    }

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerTo').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
        $('#datetimepickerContract').datetimepicker(options);
        $('#datetimepickerBirthday').datetimepicker(options);

        $('#datetimepickerDMGFrom').datetimepicker(options);
        $('#datetimepickerDMGTo').datetimepicker(options);

        $('#datetimepickerLinked').datetimepicker(options);
        $('#datetimepickerDoc').datetimepicker(options);

        $('#datetimepickerSvcFrom').datetimepicker(options);
        $('#datetimepickerSvcTo').datetimepicker(options);

        $('#datetimepickerCostFrom').datetimepicker(options);

        $('#datetimepickerSvcBundleFrom').datetimepicker(options);
        $('#datetimepickerSvcBundleTo').datetimepicker(options);
    }

    function SetName() {
        $('#accountTitle').hide();
        $('#accountName').text($('#AbonentName').val());
        $('#editTitle').show();
    }

    function CloseEditSection() {
        $('#editTitle').hide();
        $('#accountTitle').show();
        $('#accountsSection').slideDown('fast');
        $('#editSection').slideUp('fast');
        UpdateFreeData();
    }

    function AddToFileds(name) {
        console.log(name + ' was edited.');
        if (name !== undefined && fields.indexOf(name) === -1)
            fields.push(name);
    }

    function AddToDTFileds(name) {
        console.log(name + ' was edited.');
        if (name !== undefined && fieldsDate.indexOf(name) === -1)
            fieldsDate.push(name);
    }

    function UpdateBandleButtonUI() {
        $('#btnDeactivate').prop('disabled', selectedBundle === null);
    }

    function LoadBundles() {
        //load charged bundles
        $('#bdlsTable').load('/Services/Bundles/Get/' + $('#AbonentID').val(), AttacheventsForBundleTable);
    }

    function AttacheventsForBundleTable() {
        selectedBundle = null;

        $('#tariscope-cbundles tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedBundle = null;
            }
            else {
                selectedBundle = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-cbundles tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateBandleButtonUI();
        });

        UpdateBandleButtonUI();
    }

    function UpdateNewBundleButtonUI() {
        $('#chargeBundle').prop('disabled', selectedForChargeBundle === null);
    }

    function AttacheventsForNewBundlesTable() {
        selectedForChargeBundle = null;

        $('#tariscope-bundles tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedForChargeBundle = null;
            }
            else {
                selectedForChargeBundle = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-bundles tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateNewBundleButtonUI();
        });

        $('#tariscope-bundles').addClass('tableSM');

        $('#SvcBundleFromEnabled').prop('checked', false);
        $('#SvcBundleToEnabled').prop('checked', false);

        $('#datetimepickerSvcBundleFrom').data("DateTimePicker").setDate(new Date(1900, 0));
        $('#datetimepickerSvcBundleFrom').addClass('disDiv');

        $('#datetimepickerSvcBundleTo').data("DateTimePicker").setDate(new Date(3000, 0));
        $('#datetimepickerSvcBundleTo').addClass('disDiv');

        UpdateNewBundleButtonUI();
        $('#selectBundleModal').modal('show');
    }

    function LoadFileTypes() {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetFileTypes',
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#typesForEditing').empty();
                    $('#typesForDelete').empty();
                    $('#docTypeSelect').empty();
                    $('#AlreadyExistedFileTypes').empty();

                    for (key in response.types) {
                        $('#typesForEditing').append('<option value="' + key + '">' + response.types[key] + '</option>');
                        $('#typesForDelete').append('<option value="' + key + '">' + response.types[key] + '</option>');
                        $('#docTypeSelect').append('<option value="' + key + '">' + response.types[key] + '</option>');
                        $('#AlreadyExistedFileTypes').append('<span class="badge" style="margin-right: 5px;">' + response.types[key] + '</span>');
                    }
                }
            }
        });
    }

    function LoadServicesToCharge() {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/LoadServicesForCharge',
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#subSelectSvc').empty();

                    for (key in response.svcs) {

                        let group = '<optgroup label="' + key + '">';

                        response.svcs[key].forEach(e => {
                            group += '<option value="' + e.ID + '">' + e.Line + '</option>';
                        });

                        group += '</optgroup>';

                        $('#subSelectSvc').append(group);
                    }
                }
            }
        });
    }

    function UpdatePcostButtonUI() {
        if (selectedPersCost === null) {
            $('#btnEdit-PersSvc').prop('disabled', true);
            $('#btnDelete-PersSvc').prop('disabled', true);
        }
        else {
            $('#btnEdit-PersSvc').prop('disabled', false);
            $('#btnDelete-PersSvc').prop('disabled', false);
        }
    }

    function AttachEventsForPersoanlCost() {
        selectedPersCost = null;

        $('#tariscope-abonent-personal-cost tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedPersCost = null;
            }
            else {
                selectedPersCost = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-personal-cost tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdatePcostButtonUI();
        });

        UpdatePcostButtonUI();
    }

    function LoadPersonalCost() {
        $('#personalCostTable').load('/Subscribers/GetPersonalCostHistoryLine/' + selectedSvcCopy, AttachEventsForPersoanlCost);
        $('#persoanlCostHistoryLinemodal').modal('show');
    }

    function LoadPersonalCostText() {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetPersonalCost/' + selectedSvcCopy,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#currentPersonalCost').text(response.cost);
                    $('#resetIndividualCost').prop('disabled', response.disBtn);
                    $('#personalCostmodal').modal('show');
                }
            }
        });
    }

    function SetNameTitle() {
        if ($('#abonentEditTypeSelect').val() * 1 === 1) {
            $('#abonentNameTitle').hide();
            $('#firmNameTitle').show();
        }
        else {
            $('#abonentNameTitle').show();
            $('#firmNameTitle').hide();
        }
    }

    function UpdateAbonent() {
        let id = $('#AbonentID').val();

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAbonent/' + id,
            success: function (response) {
                if (response !== null && response.success === true) {
                    let row = $('tr > td[data-name="ID"]:contains("' + id + '")').parent();

                    $(row).find('td[data-name="Name"] > span').text(response.a.FullName);
                    $(row).find('td[data-name="FirstDN"]').text(response.a.FirstDN);
                    $(row).find('td[data-name="AbonentPlaneID"]').text(response.a.AbonentPlaneID);
                    $(row).find('td[data-name="Description"]').text(response.a.Description);
                    $(row).find('td[data-name="Information"]').text(response.a.Information);
                    $(row).find('td[data-name="ConnectDate"]').text(response.a.ConnectDate);
                    $(row).find('td[data-name="DisconnectDate"]').text(response.a.DisconnectDate);
                    $(row).find('td[data-name="AbonentType"]').text(response.a.AbonentType);
                    $(row).find('td[data-name="Address"]').text(response.a.Address);
                    $(row).find('td[data-name="PersonalCode"]').text(response.a.PersonalCode);
                    $(row).find('td[data-name="Address2"]').text(response.a.Address2);
                    $(row).find('td[data-name="TaxCode"]').text(response.a.TaxCode);
                    $(row).find('td[data-name="Code"]').text(response.a.Code);
                    $(row).find('td[data-name="ContractID"]').text(response.a.ContractID);
                    $(row).find('td[data-name="ContractDate"]').text(response.a.ContractDate);
                }
            }
        });
    }

    function ShowSaveResultModal(errors) {
        if (errors.length == 0) {
            ShowSpinner(false);
            $('#abonentSavedModal').modal('show');
        }
        else {
            $('#SavingErros').empty();
            for (var i = 0; i < errors.length; i++) {
                $('#SavingErros').append(`<li>${errors[i]}</li>`);
            }

            ShowSpinner(false);
            $('#abonentSavedWithErrorModal').modal('show');
        }
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearchServices');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            SearchServices();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //set abonent name title
    $('#abonentEditTypeSelect').change(SetNameTitle);

    //back to list
    $('#btnBack').on('click', () => {
        if (fields.length > 0 || fieldsDate.length > 0) {
            $('#unsavedModal').modal('show');
        }
        else {
            if (saved) {
                UpdateAbonent();
            }

            history.pushState('data', '', '/Subscribers/' + $('#nodeID').val());
            CloseEditSection();
        }
    });

    //exit without saving
    $('#exitWithourSaving').on('click', () => {
        $('#unsavedModal').modal('hide');
        CloseEditSection();
    });

    //all text imputs
    $('input[type="text"]').on('input', function () {
        if ($(this).attr('name') != 'search')
            AddToFileds($(this).attr('name'));
    });

    //all email imputs
    $('input[type="email"]').on('input', function () {
        AddToFileds($(this).attr('name'));
    });

    //all selectes
    $('select').change(function () {
        AddToFileds($(this).attr('name'));
    });

    //all textareas imputs
    $('textarea').on('input', function () {
        AddToFileds($(this).attr('name'));
    });

    //show modal for edit address1
    $('#btnEditAdress1').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetAddresses', () => {
            $('#editSection').slideUp('fast');
            $('#additionalSection').slideDown('fast');
        });
    });

    //virtual abonent
    $('#VirtualAbonent').change(() => {
        let e = $('input[name="personalcode"]');

        if ($('#VirtualAbonent').prop('checked') === true) {
            e.val('~');
            AddToFileds('personalcode');
        }
        else if ($('input[name="personalcode"]').val() === '~') {
            e.val('');
            AddToFileds('personalcode');
        }
    });

    //is public
    $('#ReferenceBooks').change(() => { AddToFileds('ispublic'); });

    //close success modal
    $('#abonentSavedModal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0) }, 500);
    });

    //start edit password
    $('#editPassword').on('click', () => {
        $('#editPassword').hide();
        $('#webCabinetNewPass').prop('readonly', false);
    });

    //save abonent
    $('#btnSave').on('click', () => {
        if (fields.length > 0 || fieldsDate.length > 0) {
            ShowSpinner(true);

            let editedFields = {};

            //inputs
            fields.forEach(e => {
                let val = null;

                if ($('input[name="' + e + '"]').prop('type') == 'checkbox') {
                    val = $('input[name="' + e + '"]').prop('checked');
                }
                else {
                    val = $('input[name="' + e + '"]').val();
                }

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            //selects
            fields.forEach(e => {
                let val = $('select[name="' + e + '"]').val();

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            //textareas
            fields.forEach(e => {
                let val = $('textarea[name="' + e + '"]').val();

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            let f = JSON.stringify(editedFields);

            $.ajax({
                type: "POST",
                async: false,
                url: '/Subscribers/Save/' + $('#AbonentID').val() + '/?fields=' + encodeURIComponent(f),
                traditional: true,
                success: function (response) {
                    if (response !== null) {
                        fields = [];
                        saved = true;
                        let errors = response.errors;

                        if (fieldsDate.length > 0) {

                            var formData = new FormData();

                            if (fieldsDate.indexOf('connectdate') !== -1) {
                                formData.append('connectdate', $('#datetimepickerFrom').data('date'));
                            }

                            if (fieldsDate.indexOf('disconnectdate') !== -1) {
                                formData.append('disconnectdate', $('#datetimepickerTo').data('date'));
                            }

                            if (fieldsDate.indexOf('contractdate') !== -1) {
                                formData.append('contractdate', $('#datetimepickerContract').data('date'));
                            }

                            if (fieldsDate.indexOf('birthday') !== -1) {
                                formData.append('birthday', $('#datetimepickerBirthday').data('date'));
                            }

                            $.ajax({
                                type: "POST",
                                data: formData,
                                datatype: 'application/octet-stream',
                                contentType: false,
                                processData: false,
                                traditional: true,
                                url: '/Subscribers/SaveDates/' + $('#AbonentID').val(),
                                success: function (response) {
                                    if (response !== null && response.success === true) {
                                        fieldsDate = [];
                                        ShowSaveResultModal(errors);
                                    }
                                }
                            });
                        }
                        else {
                            ShowSaveResultModal(errors);
                        }
                    }
                }
            });
        }
    });

    //date checkpoxes
    $('#FromEnabled').change(() => {
        if ($('#FromEnabled').prop('checked') === true) {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerFrom').removeClass('disDiv');
        }
        else {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerFrom').addClass('disDiv');
        }

        AddToDTFileds('connectdate');
    });
    $('#ToEnabled').change(() => {
        if ($('#ToEnabled').prop('checked') === true) {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerTo').removeClass('disDiv');
        }
        else {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(3000, 0));
            $('#datetimepickerTo').addClass('disDiv');
        }

        AddToDTFileds('disconnectdate');
    });
    $('#ContractEnabled').change(() => {
        if ($('#ContractEnabled').prop('checked') === true) {
            $('#datetimepickerContract').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerContract').removeClass('disDiv');
        }
        else {
            $('#datetimepickerContract').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerContract').addClass('disDiv');
        }

        AddToDTFileds('contractdate');
    });
    $('#BirthdayEnabled').change(() => {
        if ($('#BirthdayEnabled').prop('checked') === true) {
            $('#datetimepickerBirthday').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerBirthday').removeClass('disDiv');
        }
        else {
            $('#datetimepickerBirthday').data("DateTimePicker").setDate(new Date(2000, 0));
            $('#datetimepickerBirthday').addClass('disDiv');
        }

        AddToDTFileds('birthday');
    });

    //dt changer
    $('#datetimepickerFrom').on('dp.change', () => { AddToDTFileds('connectdate'); });
    $('#datetimepickerTo').on('dp.change', () => { AddToDTFileds('disconnectdate'); });
    $('#datetimepickerContract').on('dp.change', () => { AddToDTFileds('contractdate'); });
    $('#datetimepickerBirthday').on('dp.change', () => { AddToDTFileds('birthday'); });

    //show modal for charge bundle
    $('#btnBundles').on('click', () => {
        selectedBundle = null;
        UpdateBandleButtonUI();
        $('#chargeBundleModal').modal('show');
    });

    //show modal for deactivate bundle
    $('#btnDeactivate').on('click', () => {
        $('#chargeBundleModal').modal('hide');
        $('#confirmDeac').modal('show');
    });

    //show modal with bundles
    $('#confirmDeac').on('hidden.bs.modal', function () {
        $('#chargeBundleModal').modal('show');
        setTimeout(function () { $('body').css('padding-right', 0); }, 500);
    });

    //deacivate bundle
    $('#DeacConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Services/Bundles/DeactivateBundle/' + $('#AbonentID').val() + '/' + selectedBundle,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadServices();
                    LoadBundles();
                    $('#confirmDeac').modal('hide');
                }
            }
        });
    });

    //show modal for select bundle for charge
    $('#btnAddBundle').on('click', () => {
        $('#dnsSource').val($('option:first', $('#dnsSource')).val());
        $('#chargeBundleModal').modal('hide');
        $('#bdlsTableSelect').load('/Services/Bundles/Search/?s=', AttacheventsForNewBundlesTable);
    });

    //charge bundle
    $('#chargeBundle').on('click', () => {
        var formData = new FormData();

        formData.append('dtfrom', $('#datetimepickerSvcBundleFrom').data('date'));
        formData.append('dtto', $('#datetimepickerSvcBundleTo').data('date'));

        $.ajax({
            type: "POST",
            url: '/Services/Bundles/ChargeBundlePlus/' + $('#AbonentID').val()
                + '/' + selectedForChargeBundle
                + '/' + $('#dnsSource').val()
                + '/?Description=' + encodeURIComponent($('#descSource').val())
                + '&From=' + $('#SvcBundleFromEnabled').prop('checked')
                + '&To=' + $('#SvcBundleToEnabled').prop('checked'),
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadServices();
                    LoadBundles();
                    $('#selectBundleModal').modal('hide');
                }
            }
        });
    });

    //change active only switch
    $('#ActiveOnly').change(() => {
        $.ajax({
            type: "POST",
            url: '/Subscribers/SetActiveOnly/?Value=' + $('#ActiveOnly').prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadServices();
                }
            }
        });
    });

    //show modal for add damage
    $('#btnAdd-dmg').on('click', () => {
        $('#damageDns').prop('disabled', false);

        $('#damageID').val(0);

        $('#datetimepickerDMGFrom').data("DateTimePicker").setDate(new Date());
        $('#datetimepickerDMGTo').data("DateTimePicker").setDate(new Date());

        $('#dmgDescription').val('');

        $('#addDamage').prop('disabled', $('#damageDns').val() * 1 === 0);

        $('#newDamageModal').modal('show');
    });

    //enable button when selected dn
    $('#damageDns').change(() => {
        $('#addDamage').prop('disabled', $('#damageDns').val() * 1 === 0);
    });

    //add new damage
    $('#addDamage').on('click', () => {
        var formData = new FormData();

        formData.append('DNID', $('#damageDns').val());
        formData.append('Description', $('#dmgDescription').val());
        formData.append('From', $('#datetimepickerDMGFrom').data('date'));
        formData.append('To', $('#datetimepickerDMGTo').data('date'));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Subscribers/AddDamages/' + $('#damageID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadDamages();
                    $('#newDamageModal').modal('hide');
                }
            }
        });
    });

    //show modal for delete damage
    $('#btnDelete-dmg').on('click', () => { $('#deleteDamagemodal').modal('show'); });

    //confirm delete damage
    $('#deleteDamageConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Subscribers/DeleteDamages/' + selectedDamage,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadDamages();
                    $('#deleteDamagemodal').modal('hide');
                }
            }
        });
    });

    //show modal for edit damage
    $('#btnEdit-dmg').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Subscribers/GetDamage/' + selectedDamage,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#damageDns').prop('disabled', true);
                    $('#damageID').val(response.ID);

                    $('#damageDns').val(response.DNID);

                    $('#datetimepickerDMGFrom').data("DateTimePicker").setDate(new Date(response.FromDate));
                    $('#datetimepickerDMGTo').data("DateTimePicker").setDate(new Date(response.ToDate));

                    $('#dmgDescription').val(response.Description);

                    $('#addDamage').prop('disabled', false);

                    $('#newDamageModal').modal('show');
                }
            }
        });
    });

    //open modal to do linked copy
    $('#btnDoCopy').on('click', () => {
        $('#datetimepickerLinked').data("DateTimePicker").setDate(new Date());
        $('#TransfferBalanceLinked').prop('checked', false);
        $('#linkedCopyModal').modal('show');
    });

    //confirm create copy
    $('#btnCreateCopy').on('click', () => {
        $('#linkedCopyModal').modal('hide');
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('date', $('#datetimepickerLinked').data('date'));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: `/Subscribers/CreateLinked/${$('#AbonentID').val()}/?TransferBalance=${$('#TransfferBalanceLinked').prop('checked')}`,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.location = '/Subscribers/' + response.nodeid + '#' + response.id;
                    location.reload();
                }
            }
        });
    });

    //open modal with file types
    $('#btnEditFileTypes').on('click', () => {
        LoadFileTypes();
        $('#sectionforRenameType').hide();
        $('#fileTypeEmpty').hide();
        $('#AddNewType').val('');
        $('#btnAddNewtype').addClass('disDiv');
        $('#fileTypesmodal').modal('show');
    });

    //show error when empty file type
    $('#AddNewType').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#fileTypeEmpty').slideDown('fast');
            $('#btnAddNewtype').addClass('disDiv');
        }
        else {
            $('#fileTypeEmpty').slideUp('fast');
            $('#btnAddNewtype').removeClass('disDiv');
        }
    });

    //confirm add new file type
    $('#btnAddNewtype').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/AddFileType/?Type=' + encodeURIComponent($('#AddNewType').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadFileTypes();
                    $('#AddNewType').val('');
                    $('#btnAddNewtype').addClass('disDiv');
                    $('#typeAdded').slideDown('fast');
                    setTimeout(() => { $('#typeAdded').slideUp('fast'); }, 1500);
                }
            }
        });
    });

    //delete selected file type
    $('#btnDeletetype').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteFileType/' + $('#typesForDelete').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadFileTypes();
                    $('#fileTypeDeleted').slideDown('fast');
                    setTimeout(() => { $('#fileTypeDeleted').slideUp('fast'); }, 1500);
                }
                else {
                    $('#fileTypeDontDeleted').slideDown('fast');
                    setTimeout(() => { $('#fileTypeDontDeleted').slideUp('fast'); }, 1500);
                }
            }
        });
    });

    //show section for rename file type
    $('#btnEdittype').on('click', () => {
        $('#fileTypeDontRenamed').hide();
        $('#RenameFileType').val($("#typesForEditing option[value='" + $('#typesForEditing').val() + "']").text());
        $('#sectionforRenameType').slideDown('fast');
    });

    //show error when empty file type
    $('#RenameFileType').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#fileTypeDontRenamed').slideDown('fast');
            $('#btnAddNewtype').addClass('disDiv');
        }
        else {
            $('#fileTypeDontRenamed').slideUp('fast');
            $('#btnAddNewtype').removeClass('disDiv');
        }
    });

    //confirm rename
    $('#btnRenametype').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/RenameFileType/' + $('#typesForEditing').val() + '/?Name=' + encodeURIComponent($('#RenameFileType').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadFileTypes();
                    $('#sectionforRenameType').slideUp('fast');
                    $('#fileTypeRenamed').slideDown('fast');
                    setTimeout(() => { $('#fileTypeRenamed').slideUp('fast'); }, 1500);
                }
            }
        });
    });

    //download file
    $('#btnDownload').on('click', () => {
        window.open('/Subscribers/GetFile/' + selectedDoc, '_blank');
    });

    //upload file
    $('#btnUpload').on('click', () => { $('#FileInputUpload').click(); });

    //start upload
    $('#FileInputUpload').change(() => {

        ShowSpinner(true);

        let file = document.getElementById("FileInputUpload").files[0];

        var formData = new FormData();
        formData.append(file.name, file);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Subscribers/UploadDocument/' + $('#AbonentID').val(),
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadDocuments();
                }
                else {
                    console.log(response);
                }
            }
        });

    });

    //show modal for delete document
    $('#btnDelete-Doc').on('click', () => { $('#deleteDocumentmodal').modal('show'); });

    //confirm delete document
    $('#deleteDocument').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteDocument/' + selectedDoc,
            success: function (response) {
                if (response !== null) {
                    LoadDocuments();
                    $('#deleteDocumentmodal').modal('hide');
                }
            }
        });
    });

    //show modal for add document
    $('#btnAdd-Doc').on('click', () => {
        LoadFileTypes();

        $('#btnSaveDocument').unbind();
        $('#NewDocFileInput').unbind();

        $('#cancelEditSection').hide();
        $('#documentAddEditTitle').text($('#uploadTitle').val());
        $('#btnSaveDocument').prop('disabled', true);
        $('#docNumber').val('');
        $('#docAttr').val('');
        $('#docDescr').val('');
        $('#AbonentDocAccess').prop('checked', false);
        $('#NewDocFileInput').empty();
        $('#inputDesc').text($('#noSelected').val());
        $('#datetimepickerDoc').data("DateTimePicker").setDate(new Date());

        //upload document with settings
        $('#btnSaveDocument').on('click', () => {
            $('#addDocumentmodal').modal('hide');
            ShowSpinner(true);

            let file = document.getElementById("NewDocFileInput").files[0];

            var formData = new FormData();
            formData.append(file.name, file);
            formData.append('Number', $('#docNumber').val());
            formData.append('Attributes', $('#docAttr').val());
            formData.append('Description', $('#docDescr').val());
            formData.append('Access', $('#AbonentDocAccess').prop('checked'));
            formData.append('Date', $('#datetimepickerDoc').data('date'));
            formData.append('Type', $('#docTypeSelect').val());


            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/UploadDocumentWithSettings/' + $('#AbonentID').val(),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                error: function (jqxhr, status, errorThrown) {
                    console.log('jqxhr:');
                    console.log(jqxhr);
                    console.log('status:');
                    console.log(status);
                    console.log('errorThrown:');
                    console.log(errorThrown);

                },
                success: function (response) {
                    ShowSpinner(false);
                    LoadDocuments();
                }
            });
        });

        //file was added
        $('#NewDocFileInput').change(() => {
            $('#btnSaveDocument').prop('disabled', false);
            $('#inputDesc').text(document.getElementById("NewDocFileInput").files[0].name);
        });

        $('#addDocumentmodal').modal('show');
    });

    //show modal for replace document
    $('#btnUploadNew-Doc').on('click', () => { $('#replaceModal').modal('show'); });

    //start replacing
    $('#replaceDocBtn').on('click', () => {
        $('#replaceModal').modal('hide');
        $('#FileReplaceInputUpload').click();
    });

    //upload replacing file
    $('#FileReplaceInputUpload').change(() => {
        ShowSpinner(true);

        let file = document.getElementById("FileReplaceInputUpload").files[0];

        var formData = new FormData();
        formData.append(file.name, file);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Subscribers/ReplaceDocument/' + selectedDoc,
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                ShowSpinner(false);
                LoadDocuments();
            }
        });
    });

    //edit document
    $('#btnEdit-Doc').on('click', () => {
        LoadFileTypes();

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetDocumentInfo/' + selectedDoc,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#cancelEditSection').hide();

                    $('#btnSaveDocument').unbind();
                    $('#NewDocFileInput').unbind();

                    $('#documentAddEditTitle').text($('#editDocTitle').val());
                    $('#btnSaveDocument').prop('disabled', false);

                    $('#docNumber').val(response.doc.Number);
                    $('#docAttr').val(response.doc.Attributes);
                    $('#docDescr').val(response.doc.Description);

                    $('#docTypeSelect').val(response.doc.DocumentType);

                    $('#AbonentDocAccess').prop('checked', response.doc.VisibleToAbonent);
                    $('#NewDocFileInput').empty();
                    $('#inputDesc').text(response.doc.Name);
                    $('#datetimepickerDoc').data("DateTimePicker").setDate(new Date(response.doc.CreateDate));

                    //file was added
                    $('#NewDocFileInput').change(() => {
                        $('#cancelEditSection').slideDown('fast');
                        $('#inputDesc').text(document.getElementById("NewDocFileInput").files[0].name);
                    });

                    //upload document with settings
                    $('#btnSaveDocument').on('click', () => {
                        $('#addDocumentmodal').modal('hide');
                        ShowSpinner(true);

                        let file = document.getElementById("NewDocFileInput").files[0];

                        var formData = new FormData();

                        if (file !== null && file !== undefined) {
                            formData.append(file.name, file);
                        }


                        formData.append('Number', $('#docNumber').val());
                        formData.append('Attributes', $('#docAttr').val());
                        formData.append('Description', $('#docDescr').val());
                        formData.append('Access', $('#AbonentDocAccess').prop('checked'));
                        formData.append('Date', $('#datetimepickerDoc').data('date'));
                        formData.append('Type', $('#docTypeSelect').val());


                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/UpdateDocumentWithSettings/' + $('#AbonentID').val() + '/' + selectedDoc,
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            error: function (jqxhr, status, errorThrown) {
                                console.log('jqxhr:');
                                console.log(jqxhr);
                                console.log('status:');
                                console.log(status);
                                console.log('errorThrown:');
                                console.log(errorThrown);

                            },
                            success: function (response) {
                                ShowSpinner(false);
                                LoadDocuments();
                            }
                        });
                    });

                    $('#addDocumentmodal').modal('show');
                }
            }
        });
    });

    //cancel update file in db
    $('#cancelEditFileBtn').on('click', () => {
        $('#cancelEditSection').slideUp('fast');
        $('#inputDesc').text(selectedDocName);
        $('#NewDocFileInput').empty();
    });

    $("#subsSvcs").on('shown.bs.modal', function () {
        $('#subSelectSvc').select2({
            theme: "bootstrap",
            placeholder: 'select service',
            templateResult: function (data) {
                let r = data.text.split('|');
                var $result = $(
                    '<div class="row" style="width: 90%;">' +
                    '<div class="col-md-5">' + r[0] + '</div>' +
                    '<div class="col-md-2">' + r[1] + '</div>' +
                    '<div class="col-md-2">' + r[2] + '</div>' +
                    '<div class="col-md-3">' + r[3] + '</div>' +
                    '</div>'
                );
                return $result;
            },
            templateSelection: function (data) {
                var r = data.text.split('|');
                var $result = $('<p style="margin-top: 5px;">' + r[0] + '</p>');
                return $result;
            }
        });
    });

    //show modal for add svc
    $('#btnAdd-Svc').on('click', () => {
        setTimeout(function () {
            $('#svcSave').prop('disabled', $('#subSelectSvc').val() === null || $('#subSelectSvc').val() === undefined);
            $('#subSelectSvc').prop('disabled', false);

        }, 250);

        $('#svcSave').unbind();

        $('#datetimepickerSvcTo').addClass('disDiv');

        $('#SvcFromEnabled').prop('checked', true);
        $('#datetimepickerSvcFrom').data("DateTimePicker").setDate(new Date());

        $('#SvcToEnabled').prop('checked', false);
        $('#datetimepickerSvcTo').data("DateTimePicker").setDate(new Date(3000, 0));

        $('#subQuantSvc').val(1);
        $('#subSelectExtension').val(0);
        $('#subDescriptionSvc').val('');

        //charge svc
        $('#svcSave').on('click', () => {
            $('#subsSvcs').modal('hide');
            ShowSpinner(true);

            var formData = new FormData();
            formData.append('fromdt', $('#datetimepickerSvcFrom').data('date'));
            formData.append('todt', $('#datetimepickerSvcTo').data('date'));

            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/AssignService/' + $('#AbonentID').val()
                    + '/' + $('#subSelectSvc').val()
                    + '/' + $('#subSelectExtension').val()
                    + '/' + $('#subQuantSvc').val()
                    + '/?From=' + $('#SvcFromEnabled').prop('checked')
                    + '&To=' + $('#SvcToEnabled').prop('checked')
                    + '&Description=' + encodeURIComponent($('#subDescriptionSvc').val()),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        LoadServices();
                    }
                }
            });
        });

        $('#subsSvcs').modal('show');
    });

    //datetime service from/to 
    $('#SvcFromEnabled').change(() => {
        if ($('#SvcFromEnabled').prop('checked') === true) {
            $('#datetimepickerSvcFrom').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerSvcFrom').removeClass('disDiv');
        }
        else {
            $('#datetimepickerSvcFrom').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerSvcFrom').addClass('disDiv');
        }
    });
    $('#SvcToEnabled').change(() => {
        if ($('#SvcToEnabled').prop('checked') === true) {
            $('#datetimepickerSvcTo').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerSvcTo').removeClass('disDiv');
        }
        else {
            $('#datetimepickerSvcTo').data("DateTimePicker").setDate(new Date(3000, 0));
            $('#datetimepickerSvcTo').addClass('disDiv');
        }
    });

    //show modal for delete charged service
    $('#btnDelete-Svc').on('click', () => {
        $('#deleteSvcConfirm').prop('disabled', false);
        $('#cannotDeleteSvc').hide();
        $('#deleteChargedService').modal('show');
    });

    //confirm delete charged service
    $('#deleteSvcConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteService/' + selectedSvc,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteChargedService').modal('hide');
                    LoadServices();
                }
                else {
                    $('#cannotDeleteSvc').slideDown('fast');
                    $('#deleteSvcConfirm').prop('disabled', true);
                }
            }
        });
    });

    //show modal for edit charged svc
    $('#btnEdit-Svc').on('click', () => {
        $('#svcSave').unbind();

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetService/' + selectedSvc,
            success: function (response) {
                if (response !== null && response.success === true) {
                    setTimeout(function () {
                        $('#svcSave').prop('disabled', false);
                        $('#subSelectSvc').prop('disabled', true);

                    }, 250);

                    $('#subQuantSvc').val(response.svc.Amount);
                    $('#subDescriptionSvc').val(response.svc.Description);

                    $('#subSelectSvc').val(response.svc.ServiceID);

                    if (response.svc.DNID !== null && response.svc.DNID !== undefined)
                        $('#subSelectExtension').val(response.svc.DNID);
                    else
                        $('#subSelectExtension').val(0);

                    if (response.svc.FromDate !== null && response.svc.FromDate !== undefined) {
                        $('#SvcFromEnabled').prop('checked', true);
                        $('#datetimepickerSvcFrom').data("DateTimePicker").setDate(new Date(response.svc.FromDate));
                        $('#datetimepickerSvcFrom').removeClass('disDiv');
                    }
                    else {
                        $('#SvcFromEnabled').prop('checked', false);
                        $('#datetimepickerSvcFrom').data("DateTimePicker").setDate(new Date(1900, 0));
                        $('#datetimepickerSvcFrom').addClass('disDiv');
                    }

                    if (response.svc.ToDate !== null && response.svc.ToDate !== undefined) {
                        $('#SvcToEnabled').prop('checked', true);
                        $('#datetimepickerSvcTo').data("DateTimePicker").setDate(new Date(response.svc.ToDate));
                        $('#datetimepickerSvcTo').removeClass('disDiv');
                    }
                    else {
                        $('#SvcToEnabled').prop('checked', false);
                        $('#datetimepickerSvcTo').data("DateTimePicker").setDate(new Date(3000, 0));
                        $('#datetimepickerSvcTo').addClass('disDiv');
                    }

                    //charge svc
                    $('#svcSave').on('click', () => {
                        $('#subsSvcs').modal('hide');
                        ShowSpinner(true);

                        var formData = new FormData();
                        formData.append('fromdt', $('#datetimepickerSvcFrom').data('date'));
                        formData.append('todt', $('#datetimepickerSvcTo').data('date'));

                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/EditAssignedService/' + selectedSvc
                                + '/' + $('#subSelectExtension').val()
                                + '/' + $('#subQuantSvc').val()
                                + '/?From=' + $('#SvcFromEnabled').prop('checked')
                                + '&To=' + $('#SvcToEnabled').prop('checked')
                                + '&Description=' + encodeURIComponent($('#subDescriptionSvc').val()),
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    ShowSpinner(false);
                                    LoadServices();
                                }
                            }
                        });
                    });

                    $('#subsSvcs').modal('show');
                }
            }
        });
    });

    //show modal with personal cost
    $('#btnPersonalCost-Svc').on('click', () => {
        selectedSvcCopy = selectedSvc;
        LoadPersonalCostText();
    });

    //show modal for reset personal cost
    $('#resetIndividualCost').on('click', () => { $('#confimrResetPersonalmodal').modal('show'); });

    //confirm reset persoanl cost
    $('#resetConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/ResetPersonalCost/' + selectedSvcCopy,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confimrResetPersonalmodal').modal('hide');
                    LoadServices();
                }
            }
        });
    });

    //show modal for edit personal cost
    $('#editPersonalCost').on('click', LoadPersonalCost);

    //show modal for delete persoanl cost history item
    $('#btnDelete-PersSvc').on('click', () => {
        $('#persoanlCostHistoryLinemodal').modal('hide');

        $('#confirmDeletePersonalCost').prop('disabled', false);
        $('#cannotDeletePersonal').hide();

        $('#deletePersonalCostmodal').modal('show');
    });

    //reopen modal with personal costs table
    $('#deletePersonalCostmodal, #editPersonalCostmodal').on('hidden.bs.modal', LoadPersonalCost);

    //confirm delete personal cost item
    $('#confirmDeletePersonalCost').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeletePersonalCost/' + selectedPersCost,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadServices();
                    LoadPersonalCost();
                    $('#deletePersonalCostmodal').modal('hide');
                }
                else {
                    $('#confirmDeletePersonalCost').prop('disabled', true);
                    $('#cannotDeletePersonal').slideDown('fast');
                }
            }
        });
    });

    //show modal for add personal cost
    $('#btnAdd-PersSvc').on('click', () => {
        $('#persoanlCostHistoryLinemodal').modal('hide');

        $('#savePcost').unbind();

        $('#costIsFactor').prop('checked', false);
        $('#costFixed').show();
        $('#costFactor').hide();
        $('#costAmount').val(0);
        $('#datetimepickerCostFrom').data("DateTimePicker").setDate(new Date());
        $('#editPcostTitle').text($('#newPcost').val());

        $('#savePcost').on('click', () => {
            var formData = new FormData();
            formData.append('fromdt', $('#datetimepickerCostFrom').data('date'));

            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/AddPersonalCost/' + selectedSvcCopy
                    + '/' + $('#costAmount').val()
                    + '/?IsFactor=' + $('#costIsFactor').prop('checked'),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadServices();
                        $('#editPersonalCostmodal').modal('hide');
                    }
                }
            });
        });

        $('#editPersonalCostmodal').modal('show');
    });

    //show correct title
    $('#costIsFactor').change(() => {
        if ($('#costIsFactor').prop('checked') === true) {
            $('#costFixed').hide();
            $('#costFactor').show();
        }
        else {
            $('#costFixed').show();
            $('#costFactor').hide();
        }
    });

    //show modal for edit selected personal cost
    $('#btnEdit-PersSvc').on('click', () => {
        $.ajax({
            type: 'POST',
            async: true,
            url: '/Subscribers/GetPersonalCostInfo/' + selectedPersCost,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#persoanlCostHistoryLinemodal').modal('hide');

                    $('#savePcost').unbind();

                    if (response.cost.IsFactor * 1 === 1) {
                        $('#costFixed').hide();
                        $('#costFactor').show();
                        $('#costIsFactor').prop('checked', true);
                        $('#costAmount').val(response.cost.Factor);
                    }
                    else {
                        $('#costFixed').show();
                        $('#costFactor').hide();
                        $('#costIsFactor').prop('checked', false);
                        $('#costAmount').val(response.cost.FeeAmount);
                    }

                    $('#datetimepickerCostFrom').data("DateTimePicker").setDate(new Date(response.cost.FromDate));
                    $('#editPcostTitle').text($('#editPcost').val());

                    $('#savePcost').on('click', () => {
                        var formData = new FormData();
                        formData.append('fromdt', $('#datetimepickerCostFrom').data('date'));

                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/EditPersonalCost/' + selectedPersCost
                                + '/' + $('#costAmount').val()
                                + '/?IsFactor=' + $('#costIsFactor').prop('checked'),
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    LoadServices();
                                    $('#editPersonalCostmodal').modal('hide');
                                }
                            }
                        });
                    });

                    $('#editPersonalCostmodal').modal('show');
                }
            }
        });
    });

    //open section for contacts
    $('#contactsBtn').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetContactsSection', () => {
            $('#editSection').slideUp('fast');
            $('#additionalSection').slideDown('fast');
        });
    });

    //open section for aux ids
    $('#opeauxBtn').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetAuxes', () => {
            $('#editSection').slideUp('fast');
            $('#additionalSection').slideDown('fast');
        });
    });

    //open section for extensions
    $('#extensionsBtn, #ipsBtn').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetExtensions', () => {
            $('#editSection').slideUp('fast');
            $('#additionalSection').slideDown('fast');
        });
    });

    //open section for plans
    $('#rateplanBtn').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetAbonentPlans', () => {
            $('#editSection').slideUp('fast');
            $('#additionalSection').slideDown('fast');
        });
    });

    //go to bill details
    $('#showBillDetails').on('click', () => { window.location = '/AccountSummary#' + $('#AbonentID').val(); });

    //datetime service bundles from/to 
    $('#SvcBundleFromEnabled').change(() => {
        if ($('#SvcBundleFromEnabled').prop('checked') === true) {
            $('#datetimepickerSvcBundleFrom').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerSvcBundleFrom').removeClass('disDiv');
        }
        else {
            $('#datetimepickerSvcBundleFrom').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerSvcBundleFrom').addClass('disDiv');
        }
    });
    $('#SvcBundleToEnabled').change(() => {
        if ($('#SvcBundleToEnabled').prop('checked') === true) {
            $('#datetimepickerSvcBundleTo').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerSvcBundleTo').removeClass('disDiv');
        }
        else {
            $('#datetimepickerSvcBundleTo').data("DateTimePicker").setDate(new Date(3000, 0));
            $('#datetimepickerSvcBundleTo').addClass('disDiv');
        }
    });

    //show modal to eit address
    $('#btnEditBankAddress').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetBankAddress/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#bank_ID').val(response.address.ID);
                    $('#bank_Name').val(response.address.Name);
                    $('#bank_City').val(response.address.City);
                    $('#bank_ZipCode').val(response.address.ZipCode);
                    $('#bank_Area').val(response.address.Area);
                    $('#bank_Street').val(response.address.Street);
                    $('#bank_Building').val(response.address.Building);
                    $('#bank_House').val(response.address.House);
                    $('#bank_Floor').val(response.address.FloorNumber);
                    $('#bank_Flat').val(response.address.Flat);

                    $('#btnSaveBankAddress').unbind();
                    $('#btnSaveBankAddress').on('click', () => {
                        ShowSpinner(true);

                        var formData = new FormData();

                        formData.append('Name', $('#bank_Name').val());
                        formData.append('City', $('#bank_City').val());
                        formData.append('ZipCode', $('#bank_ZipCode').val());
                        formData.append('Area', $('#bank_Area').val());
                        formData.append('Street', $('#bank_Street').val());
                        formData.append('Building', $('#bank_Building').val());
                        formData.append('House', $('#bank_House').val());
                        formData.append('Floor', $('#bank_Floor').val());
                        formData.append('Flat', $('#bank_Flat').val());

                        $.ajax({
                            type: "POST",
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            url: '/Subscribers/UpdateAddress/' + $('#bank_ID').val(),
                            success: function (response) {
                                ShowSpinner(false);

                                $.ajax({
                                    type: "POST",
                                    data: formData,
                                    datatype: 'application/octet-stream',
                                    contentType: false,
                                    processData: false,
                                    traditional: true,
                                    url: '/Subscribers/GetBankAddress/' + $('#AbonentID').val(),
                                    success: function (response) {
                                        $('#BankAddress').val((response.address.Street + " " + response.address.House + " - " + response.address.Flat + " " + response.address.Area + " " + response.address.City + " " + response.address.ZipCode).trim());
                                    }
                                });
                            }
                        });
                    });

                    $('#BankAddressModal').modal('show');
                }
            }
        });
    });

    initdatetime();
    SetName();
    LoadServices();
    LoadBundles();
    LoadDns();
    LoadDamages();
    LoadBill();
    LoadDocuments();
    LoadServicesToCharge();
    SetNameTitle();
});