﻿$(document).ready(() => {
    function LoadSettings() {
        $.ajax({
            type: "POST",
            url: '/HotelSystem/GetSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#conectionform').val(response.DataSource);
                    $('#logLevel').val(response.LogLevel);
                    $('#scriptsSelect').val(response.ScriptName);
                    $('#openOnStart').prop('checked', response.AutoOpenDataSource === true);
                }
            }
        });
    }

    function AttachSubmit() {
        //attach submit event to form and open modal
        var frm = $('#connectionTypeForm');
        frm.submit(function (ev) {
            $.ajax({
                type: frm.attr('method'),
                url: frm.attr('action'),
                data: frm.serialize(),
                success: function (e) {
                    $('#settingsModal').modal('hide');
                }
            });

            ev.preventDefault();
        });

        $('#settingsModal').modal('show');
    }

    //open window with settings for selected connection
    $('#btnEditConnection').on('click', () => {
        let i = $('#conectionform').val();

        switch (i) {
            case "Rlogin client":
                $('#settingsConcentrator').load('/HotelSystem/Settings/RLogin', AttachSubmit);
                break;
            case "Serial port":
                $('#settingsConcentrator').load('/HotelSystem/Settings/SerialPort', AttachSubmit);
                break;
            case "SSH Client":
                $('#settingsConcentrator').load('/HotelSystem/Settings/SSHClient', AttachSubmit);
                break;
            case "TCP Client":
                $('#settingsConcentrator').load('/HotelSystem/Settings/TCPIPClient', AttachSubmit);
                break;
            case "TCP":
                $('#settingsConcentrator').load('/HotelSystem/Settings/TCPIPServer', AttachSubmit);
                break;
            case "Asterisk AMI":
                $('#settingsConcentrator').load('/HotelSystem/Settings/AsteriskAMI', AttachSubmit);
                break;
            default:
                break;
        }
    });

    //open modal with editor for script
    $('#btnEditScenario').on('click', () => {
        let name = $('#scriptsSelect').val();

        if (!(!name || !name.trim())) {
            $('#editScriptName').text(name);
            $('#modalEditorBody').load('/HotelSystem/GetEditor/?file=' + encodeURIComponent(name), () => {

                window.SQLEditor.on("change", () => {
                    $('#btnSaveScript').show();
                });

                $('#btnSaveScript').hide();
                $('#editmodal').modal('show');
            });
        }
    });

    //save edited filter
    $('#btnSaveScript').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/HotelSystem/SaveScript/?name=' + encodeURIComponent($('#scriptsSelect').val()),
            traditional: true,
            data: { code: window.SQLEditor.getValue() },
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#scriptSavedLbl').slideDown('fast');
                    setTimeout(() => { $('#scriptSavedLbl').slideUp('fast'); }, 2500);
                    $('#btnSaveScript').hide();
                }
            }
        });
    });



    //save svc config
    $('#btnSave').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/HotelSystem/Settings/Save/?DataSource=' + encodeURIComponent($('#conectionform').val()) +
                "&AutoOpenDataSource=" + $('#openOnStart').prop('checked') +
                "&ScriptName=" + encodeURIComponent($('#scriptsSelect').val()) +
                "&LogLevel=" + $('#logLevel').val(),
            traditional: true,
            success: function (response) {
                window.open('/HotelSystem', '_parent');
            }
        });
    });

    //change auth type
    $('#sqlAuthType').change(() => {
        if ($('#sqlAuthType').val() * 1 === 0) {
            $('#sqlCredentialsPanel').addClass('disDiv');
        }
        else {
            $('#sqlCredentialsPanel').removeClass('disDiv');
        }
    });

    LoadSettings();
});