﻿$(document).ready(() => {
    let Loading = `<br /><div class="well well-sm"><div class="text-center">${$('#LoadingLbl').val()}</div></div>`
    let IsRAW = false;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: `/CallTracing/Export/?CallID=${$('#CallID').val()}&type=${t}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/CallTracing/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function LoadCallData() {
        $('#CallDataSection').html(Loading);
        $('#CallDataSection').load(`/Tracing/${$('#CallID').val()}/data`);
    }

    function LoadHumanData() {
        $('#rechargeDataTable').html(Loading);

        $('#ExportDelimiter').hide();
        $('#ExportButtons').hide();
        $('#btnShowHumanReadable').hide();
        $('#btnShowRaw').show();

        $('#rechargeDataTable').load(`/Tracing/${$('#CallID').val()}/human`, () => {
            IsRAW = false;
            LoadCallData();
        });
    }

    function LoadRAWData() {
        $('#rechargeDataTable').html(Loading);

        $('#btnShowRaw').hide();
        $('#ExportDelimiter').show();
        $('#ExportButtons').show();
        $('#btnShowHumanReadable').show();

        $('#rechargeDataTable').load(`/Tracing/${$('#CallID').val()}/raw`, () => {
            IsRAW = true;
            LoadCallData();
        });
    }

    //show raw table
    $('#btnShowRaw').on('click', LoadRAWData);

    //show human redabe data
    $('#btnShowHumanReadable').on('click', LoadHumanData);

    //refresh curren table
    $('#btnRefresh').on('click', () => {
        if (IsRAW) {
            LoadRAWData();
        }
        else {
            LoadHumanData();
        }
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    LoadHumanData();
});