﻿using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.HotelSystems.Scripting.Interfaces;
using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.InteropServices;

public class PrintScript : IScript
{
    private IScriptHost Host;

    private bool NeedFinish = false;
    private System.Threading.Thread ProcessingThread;
    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        ProcessingThread = new System.Threading.Thread(ThreadProcessing)
        {
            Name = "LPT Print script thread"
        };

        ProcessingThread.Start();
    }
    private void OnClose(ref bool Cancel)
    {
        if (ProcessingThread != null)
        {
            NeedFinish = true;
            ProcessingThread.Join();
        }

        return;
    }
    public void Main(object Parameters)
    {
    }

    public void ThreadProcessing()
    {
        try
        {
            while (true)
            {
                List<CallItemExport> Items = Host.GetItems();
                while (Items.Count > 0)
                {
                    Host.AddEvent(string.Format("Writing {0} items", Items.Count), 6);
                    var itm = Items[0];
                    try
                    {
                        PrintFactory.SendTextToLPT1(string.Format("{0}, From {1} to {2}, {3} seconds, Cost: {4}{5}", itm.Datetime, itm.DN, itm.Dialnumber, itm.DurationSeconds, itm.Cost, "\r\n"));
                    }
                    catch (IOException ex)
                    {
                    }
                    Items.RemoveAt(0);
                }
                if (NeedFinish)
                    break;
                System.Threading.Thread.Sleep(100);
            }
        }
        catch (System.Threading.ThreadAbortException)
        {
            Host.AddEvent("Export thread terminated", 6);
        }

        ProcessingThread = null;

        return;
    }
}

public class PrintFactory
{
    const short FILE_ATTRIBUTE_NORMAL = 0x80;
    const short INVALID_HANDLE_VALUE = -1;
    const uint GENERIC_READ = 0x80000000U;
    const uint GENERIC_WRITE = 0x40000000;
    const uint CREATE_NEW = 1;
    const uint OPEN_EXISTING = 3;

    [DllImport("kernel32.dll", SetLastError = true)]
    private static extern IntPtr CreateFile(string lpFileName, uint dwDesiredAccess, uint dwShareMode, IntPtr lpSecurityAttributes, uint dwCreationDisposition, uint dwFlagsAndAttributes, IntPtr hTemplateFile);

    public static void SendTextToLPT1(String receiptText)
    {
        IntPtr ptr = CreateFile("LPT1", GENERIC_WRITE, 0, IntPtr.Zero, OPEN_EXISTING, 0, IntPtr.Zero);

        // Is bad handle? INVALID_HANDLE_VALUE 

        if (ptr.ToInt32() == -1)
            // ask the framework to marshall the win32 error code to an exception 
            Marshal.ThrowExceptionForHR(Marshal.GetHRForLastWin32Error());
        else
        {
            FileStream lpt = new FileStream(ptr, FileAccess.ReadWrite);
            Byte[] buffer = new Byte[2048];
            // If unicode is supported, use the following:
            // buffer = System.Text.Encoding.Unicode.GetBytes(Temp);
            buffer = System.Text.Encoding.ASCII.GetBytes(receiptText);
            lpt.Write(buffer, 0, buffer.Length);
            lpt.Close();
        }
    }
}