﻿$(document).ready(function () {

    var selectedRPID = null;
    var selectedServiceID = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/RatePlanes/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/RatePlanes/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function DeleteService() {
        /*deleting service and update table with services*/
        $.ajax({
            type: "POST",
            url: '/RatePlanes/DeleteRatePlane/' + selectedRPID,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTable($('#tbSearch').val());
                    selectedRPID = null;
                    UpdateMainButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#cannotDelete').attr('hidden', false);
                }
            }
        });
    }

    function RenameService() {
        /*renaming rate plane and update table with rate plans*/
        $.ajax({
            type: "POST",
            url: '/RatePlanes/RenameRatePlane/?id=' + selectedRPID + '&newName=' + encodeURIComponent($('#renameRPName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTable($('#tbSearch').val())
                    selectedRPID = null;
                    UpdateMainButtonsUI();
                    $('#renameRPModal').modal('hide');
                }
            }
        });
    }

    function ShowRenameRateModal() {
        /*attach event to text box with name*/
        /*show alert message when name is empty*/
        $('#renameRPName').on('input', function (e) {
            if ($('#renameRPName').val() === "") {
                $('#emptyRename').attr('hidden', false);
                $('#modalButtonRename').attr('disabled', true);
            }
            else {
                $('#emptyRename').attr('hidden', true);
                $('#modalButtonRename').attr('disabled', false);
            }
        });

        /*showing rename modal dialog*/
        $.ajax({
            type: "POST",
            url: '/RatePlanes/GetRatePlaneName/' + selectedRPID,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#emptyRename').attr('hidden', true);
                    $('#modalButtonRename').attr('disabled', false);
                    $('#renameRPName').val(response.Name);
                    $('#renameRPModal').modal('show');
                }
            }
        });
    }

    function UpdateMainButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedRPID === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnRename").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnRename").attr("disabled", false);
        }
    }

    function AttachEventsMainTable() {

        /*table events*/
        $('#tariscope-rp tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedRPID = null;
            }
            else {
                selectedRPID = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-rp tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        /*attach events for export*/
        $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
        $('#ExportHTML').on('click', function () { Export("html"); });
        $('#ExportCSV').on('click', function () { Export("csv"); });
        $('#ExportPDF').on('click', function () { Export("pdf"); });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/RatePlanes/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTable($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTable(e) {
        /*update table by search string*/
        $('#rpTable').load(encodeURI('/RatePlanes/Search/?s=' + e), AttachEventsMainTable);
    }

    function initDateTimePicker() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: navigator.language,
            locale: navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(options);
        $('#datetimepickerTo').datetimepicker(options);
    }

    function AddEditService() {
        var ID = '?ID=' + selectedServiceID;
        var PlaneID = '&PlaneID=' + $('#ratePlaneForEdit').val();
        var ServiceID = '&ServiceID=' + $('#SelectedService option:selected').val();
        var Amount = '&Amount=' + $('#SelectedServiceAmount').val();
        var Description = '&Description=' + $('#SelectedServiceDescription').val();

        var From = '&From=' + $('#datetimepickerFrom').data('date');
        var To = '&To=' + $('#datetimepickerTo').data('date');

        $.ajax({
            type: "POST",
            url: '/RatePlanes/AddService/' + ID + PlaneID + ServiceID + Amount + Description + From + To,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    selectedServiceID = null;
                    UpdateServiceButtonsUI();

                    $('#servicesTable').load('/RatePlanes/LoadServicesTable/' + $('#ratePlaneForEdit').val(), AttachEventOnServicesTable);
                    $('#editServiceModal').modal('hide');
                }
            }
        });
    }

    function AttachEventsOnEdit() {
        /*hide load spiner when page is loaded*/
        ShowSpinner(false);

        /*attach event to cancle button*/
        $('#cancelEdit').on('click', LoadPreview);

        /*add service (open modal)*/
        $('#editServiceToolButtons').on('click', 'button[data-name="Add"]', function () {
            selectedServiceID = null;

            $('#addModalServiceHeader').attr('hidden', false);
            $('#editModalServiceHeader').attr('hidden', true);

            try { $('#datetimepickerFrom').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); }
            try { $('#datetimepickerTo').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); }

            $('#ServiceItemID').val('0');
            $("#SelectedService").val($("#SelectedService option:first").val());
            $('#SelectedServiceDescription').val('');
            $('#SelectedServiceAmount').val('1');

            $('#editServiceModal').modal('show');
        });

        /*edit service (open modal)*/
        $('#editServiceToolButtons').on('click', 'button[data-name="Edit"]', function () {
            $('#addModalServiceHeader').attr('hidden', true);
            $('#editModalServiceHeader').attr('hidden', false);

            $.ajax({
                type: "POST",
                url: '/RatePlanes/GetService/?ID=' + selectedServiceID + '&PlaneID=' + $('#ratePlaneForEdit').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#ServiceItemID').val(response.ID);
                        $('#SelectedServiceDescription').val(response.Description);
                        $('#SelectedServiceAmount').val(response.Amount);
                        $('#SelectedService option[value="' + response.ServiceID + '"]').attr('selected', 'true');

                        try { $('#datetimepickerFrom').data("DateTimePicker").setDate(response.From !== null ? new Date(response.From) : null); } catch (e) { console.log(e); }
                        try { $('#datetimepickerTo').data("DateTimePicker").setDate(response.To !== null ? new Date(response.To) : null); } catch (e) { console.log(e); }


                        $('#editServiceModal').modal('show');
                    }
                }
            });


        });

        //load table with applied services
        $('#servicesTable').load('/RatePlanes/LoadServicesTable/' + $('#ratePlaneForEdit').val(), AttachEventOnServicesTable);

        //attach event to add/edit service button
        $('#btnAddEditService').on('click', AddEditService);

        //attach events to buttons for clear data (fromdate, todate)
        $('#btnClearToDate').on('click', function () { try { $('#datetimepickerTo').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); } });
        $('#btnClearFromDate').on('click', function () { try { $('#datetimepickerFrom').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); } });

        //attach events to button for delete servie
        $('#btnDelete-Service').on('click', function () { $('#confirmDeleteService').modal('show'); });
        $('#DeleteConfirmService').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/RatePlanes/DeleteService/?ID=' + selectedServiceID + '&PlaneID=' + $('#ratePlaneForEdit').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        selectedServiceID = null;
                        UpdateServiceButtonsUI();

                        $('#servicesTable').load('/RatePlanes/LoadServicesTable/' + $('#ratePlaneForEdit').val(), AttachEventOnServicesTable);
                        $('#confirmDeleteService').modal('hide');
                    }
                }
            });
        });

        if ($('#ratePlaneForEdit').val() !== '0') {
            $('#lblAdd').attr('hidden', true);
            $('#lblEdit').attr('hidden', false);
            $('#lblKdb').html($('#rateName').val());
        }
        else {
            $('#lblAdd').attr('hidden', false);
            $('#lblEdit').attr('hidden', true);
        }

        initDateTimePicker();
    }

    function LoadTable() {
        /*first load table*/

        /*atach input event to search textbox*/
        $('#tbSearch').on('input', function (e) { UpdateTable($('#tbSearch').val()); });

        /*attach events for select column*/
        $('#MenuSelectColumn input').on('click', function (event) {

            var visible = $(event.target).prop('checked');
            var colName = $(event.target).attr('data-value');

            $.ajax({
                type: "POST",
                url: '/RatePlanes/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        selectedRPID = null;
                        UpdateMainButtonsUI();
                        UpdateTable('');
                    }
                }
            });
        });

        /*attach event to Rename button*/
        $('#btn-tools').on('click', 'button[data-name="Rename"]', ShowRenameRateModal);

        /*attach event to delete button*/
        $('#modalButtonRename').on('click', RenameService);

        /*attach events for deleting service*/
        $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
            $('#cannotDelete').attr('hidden', true);
            $('#confirmDelete').modal('show');
        });
        $('#DeleteConfirm').on('click', DeleteService);

        /*attach event to Add button*/
        $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
            /*show load msg*/
            ShowSpinner(true);
            $('#RPContent').load('/RatePlanes/AddRatePlane/', AttachEventsOnEdit);
        });

        /*attach event to Edit button*/
        $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
            /*show load msg*/
            ShowSpinner(true);
            $('#RPContent').load('/RatePlanes/EditRatePlane/' + selectedRPID, AttachEventsOnEdit);
        });

        /*load table with rate plans*/
        UpdateTable('');
    }

    function UpdateServiceButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedServiceID === null) {
            $("#btnEdit-Service").attr("disabled", true);
            $("#btnDelete-Service").attr("disabled", true);
        }
        else {
            $("#btnEdit-Service").attr("disabled", false);
            $("#btnDelete-Service").attr("disabled", false);
        }
    }

    function AttachEventOnServicesTable() {
        /*attach events to table with services*/
        $('#tariscope-rp-services tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedServiceID = null;
            }
            else {
                selectedServiceID = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-rp-services tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateServiceButtonsUI();
        });
    }

    function LoadPreview() {
        /*load preview*/
        $('#RPContent').load('/RatePlanes/GetPreview/', LoadTable);
    }

    LoadPreview();
});