﻿{
    let deferredPrompt;

    function setCookie(cname, cvalue) {
        var d = new Date();
        d.setTime(d.getTime() + (1000 * 24 * 60 * 60 * 1000));
        var expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return false;
    }

    function showInstallPromotion() {
        setCookie("DontShowPWARocket", true);

        $('#InstallPWAModal').modal('show');

        $('#AddPWAButton').on('click', () => {
            $('#PWAInstallButtonSection').addClass('disDiv');
            deferredPrompt.prompt();
            deferredPrompt.userChoice.then((choiceResult) => {
                if (choiceResult.outcome === 'accepted') {
                    $('#InstallPWAModal').modal('hide');
                } else {
                    $('#PWAInstallButtonSection').removeClass('disDiv');
                }
                deferredPrompt = null;
            });
        })
    }


    window.addEventListener('beforeinstallprompt', (e) => {
        deferredPrompt = e;

        if (getCookie("DontShowPWARocket") === false)
            showInstallPromotion();
    });
}