﻿$(document).ready(() => {
    function CheckIssueType() {
        //hide add attachments when issue type without attouchment
        $.ajax({
            type: "POST",
            url: '/PersonalArea/Service/Issues/WithAttachment/' + $('#IssueTypeID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.use === true) {
                        $('#FileInput').val('');
                        $('#addAttachments').slideDown('fast');
                        $('#attSize').text(response.size);
                    }
                    else {
                        $('#addAttachments').slideUp('fast');
                    }
                }
            }
        });
    }

    //change issue types
    $('#IssueTypeID').change(CheckIssueType);

    //click select attach
    $('#addAttachments').on('click', () => {
        $('#FileInput').val('');
        $('#attFileName').slideUp('fast');
        $('#FileInput').click();
    });

    //uploading attachment
    $("#FileInput").change(function () {
        ShowSpinner(true);

        var formData = new FormData();
        formData.append(document.getElementById("FileInput").files[0].name, document.getElementById("FileInput").files[0]);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/PersonalArea/Service/Issues/Upload/' + $('#IssueTypeID').val(),
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                ShowSpinner(false);

                if (response.success === true) {
                    $('#AttachmentPath').val(response.path);
                    $('#attFileName').text(response.name);
                    $('#attFileName').slideDown('fast');
                }
                else {
                    $('#uploadError').text(response.msg);
                    $('#modalUploadError').modal('show');
                }
            }
        });
    });

    CheckIssueType();
});