﻿$(document).ready(() => {
    let loading = `<br /><div class="well well-sm"><div class="text-center">${$('#LoadingLbl').val()}</div></div>`;

    function AttachEventsMainTable() {
        $('.department-link').on('click', function () {
            $('#tbSearch').val('');
            LoadTable($(this).data('id'));
        });
    }

    function LoadTable(id) {
        $('#phonesTable').html(loading);
        $('#phonesTable').load('/PersonalArea/Service/Phones/Load/' + id, AttachEventsMainTable);
    }

    function LoadTableSearch(id, search) {
        $('#phonesTable').load('/PersonalArea/Service/Phones/Search/' + id + '/?Search=' + encodeURIComponent(search), AttachEventsMainTable);
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            if ($input.val() == null || $input.val() == '') {
                LoadTable($('#CurrentDepartment').val());
            }
            else {
                LoadTableSearch($('#CurrentDepartment').val(), $input.val());
            }
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    LoadTable(0);
});