﻿$(document).ready(() => {
    let startIp = 1000000;

    function ValidateIPaddress(inputText) {
        var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        if (inputText.match(ipformat)) {
            return true;
        }
        else {
            return false;
        }
    }

    //add a new ip or host name
    $('#addIpOrHost').on('click', () => {
        if (!$('#ipOrHost').val() || !$('#ipOrHost').val().trim() || !ValidateIPaddress($('#ipOrHost').val())) {
            $('#emptyIpOrHost').slideDown('fast');
            setTimeout(() => { $('#emptyIpOrHost').slideUp('fast') }, 2000);
        }
        else {
            $('#insertBase').append('<div id="record_' + startIp + '" class="input-group form-group">' +
                '<input class="form-control" id="Sources' + startIp + '_" name="Sources[' + startIp + ']" readonly="readonly" type="text" value="' + $('#ipOrHost').val() + '"/>' +
                '<input class="form-control" id="Sensors' + startIp + '_" name="Sensors[' + startIp + ']" readonly="readonly" type="text" value="' + $('#ipOrHost').val() + '" style="display:none;"/>' +
                '<span class="input-group-btn">' +
                '<button class="btn btn-default deleteRecord" type="button" data-record="' + startIp + '"><i class="fa fa-trash"></i></button></span></div>');
            startIp++;

            $('#ipOrHost').val('');

            $('.deleteRecord').click(function () {
                $('#record_' + $(this).data('record')).remove();
            });
        }
    });

    //delete record
    $('.deleteRecord').click(function () {
        $('#record_' + $(this).data('record')).remove();
    });
});