﻿$(document).ready(() => {
    function InitPBXSelect() {
        //types
        $('#pbxTypes').select2({
            theme: "bootstrap",
            templateResult: function (data) {
                let r = data.text.split('~');
                var $result = $(
                    '<div class="row" style="width: 90%;">' +
                    '<div class="col-md-4">' + r[0] + '</div>' +
                    '<div class="col-md-8">' + r[1] + '</div>' +
                    '</div>'
                );
                return $result;
            },
            templateSelection: function (data) {
                var r = data.text.split('~');
                var $result = $('<p style="margin-top: 5px;">' + r[0] + '</p>');
                return $result;
            }
        });
    }

    function InitPBXType() {
        $('#pbxTypes').prepend('<optgroup label="Name~Suportet hardwares"></optgroup>');
        $('#pbxTypes').val('Auto');
        InitPBXSelect();
    }

    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('DeviceID', $('#DeviceID').val());
        formData.append('pbxTypes', $('#pbxTypes').val());
        formData.append('FLOWIDs', $('#FLOWIDs').val());
        formData.append('ObserverType', $('#DataSourceType').val());
        formData.append('DataSourceConfiguration', $('#DataSourceConfiguration').val());
        formData.append('EnableFLOW', $('#EnableFLOW').prop('checked'));
        formData.append('CreateObserver', $('#CreateObserver').prop('checked'));
        formData.append('AggregateToNetowrks', $('#AggregateToNetowrks').prop('checked'));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step3_v/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ObserverName').val(response.Observer);
                    GoNext();
                }
                else { ShowError(response.Errors); }
            }
        });
    }

    function AddScript(addrr) {
        var s = document.createElement("script");
        s.type = "text/javascript";
        s.src = addrr;
        s.innerHTML = null;
        s.id = "addrr";
        document.getElementById("scriptSection").innerHTML = "";
        document.getElementById("scriptSection").appendChild(s);
    }

    //setup current step
    $('#CurrentStep').val(3);

    //go to the next step
    $('#NextStep').on('click', SendData);

    //update pbxtype
    $('#pbxTypes').change(() => {
        if ($('#pbxTypes').val().includes('NetFlow sensor')) {
            $('#flowSection').slideDown('fast');
        }
        else {
            $('#flowSection').slideUp('fast');
        }

        $.ajax({
            type: "POST",
            url: '/Devices/PBXInfo/?Name=' + encodeURIComponent($('#pbxTypes').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.config) {
                        $('#PBXConfigBtn').show();
                    }
                    else {
                        $('#PBXConfigBtn').hide();
                    }
                }
                InitPBXSelect();
            }
        });
    });

    //disable sections
    $('#EnableFLOW').change(() => {
        if ($('#EnableFLOW').prop('checked')) {
            $('#NetFlowbody').removeClass('disDiv');
        }
        else {
            $('#NetFlowbody').addClass('disDiv');
        }
    });
    $('#CreateObserver').change(() => {
        if ($('#CreateObserver').prop('checked')) {
            $('#CreateObserverSection').removeClass('disDiv');
        }
        else {
            $('#CreateObserverSection').addClass('disDiv');
        }
    });

    //show configurations
    $('#PBXConfigBtn').on('click', () => {
        AddScript("/js/Devices/processConfig.js");
        $('#parserConfig').load('/Devices/Configuration/' + $('#DeviceID').val() + '/?Name=' + encodeURIComponent($('#pbxTypes').val()), () => { $('#parserConfigModal').modal('show'); });
    });

    //show configurations
    $('#ObserverConfigBtn').on('click', () => {
        AddScript("/js/Observers/processConfig.js");
        $('#dsConfig').load('/Observers/Configuration/' + encodeURIComponent($('#DataSourceType').val()) + '/-', () => { $('#dsConfigModal').modal('show'); });
    });

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });

    InitPBXType();
});