﻿$(document).ready(() => {
    let selectedBranch;
    let selectedDep;
    let sendState = null;
    let itwascheck = false;

    //Connection to LDAP server
    function ShowConnectionMessage(success, message, url) {
        ShowSpinner(false);

        if (success === true) {
            $('#connectUrl').val(url);
            $('#pSuccess').text(message);
            $('#Successdmodal').modal('show');
            LoadLeftTree();
            LoadRightTable();

            EnableNext(true);
        }
        else {
            $('#pError').text(message);
            $('#Errordmodal').modal('show');

            $('#treeConcentrator').empty();
            $('#acConcentrator').empty();

            EnableNext(false);
        }
    }

    function LoadLeftTree()
    {
        var Editing = $('#Editing').text();
        $('#treeConcentrator').load('/ADSync/GetChildren/?Editing=' + Editing, AttachEventsToLeftTree);
    }

    function LoadRightTable() {
        $('#acConcentrator').load('/ADSync/GetAttributes/?GUID=' + (selectedBranch === null ? "" : encodeURIComponent(selectedBranch)));
    }

    function AttachEventsToDepsTree() {
        var editSign = $('#Editing').text();
        if ($('#Editing').text() === "True") {
            EnableNext(true);
            $('.treeDeps').treegrid({
                expanderExpandedClass: 'glyphicon glyphicon-minus',
                expanderCollapsedClass: 'glyphicon glyphicon-plus',
                initialState: 'expanded',
                saveState: true
            });
        }
        $('#tariscope-department tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDep = null;

                $('#departmentID').val('0');
                EnableNext(false);
            }
            else {
                selectedDep = $(this).find('td[data-name="ID"]').text();

                if (selectedDep !== null && selectedDep) {
                    $('#tariscope-department tr.selected').removeClass('selected');
                    $(this).addClass('selected');

                    $('#departmentID').val(selectedDep + '');
                    EnableNext(true);
                }
                else {
                    selectedDep = null;
                }

            }
        });
    }

    function LoadDepartments() {
        selectedDep = null;
        $('#departmentID').val('0');
        $('#dpConcentrator').load('/ADSync/GetDepartment', AttachEventsToDepsTree)
    }

    function AttachEventsToLeftTree() {
        //table
        $('#tariscope-elements tbody').on('click', 'tr', function () {
            if (sendState === null) {

                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    selectedBranch = null;
                }
                else {
                    selectedBranch = $(this).find('td[data-name="GUID"]').text();
                    $('#tariscope-elements tr.selected').removeClass('selected');
                    $(this).addClass('selected');

                    setTimeout(() => {
                        if (itwascheck === true) {
                            itwascheck = false;
                        }
                        else {
                            $('#treeConcentrator').load('/ADSync/GetChildren/?GUID=' + encodeURIComponent(selectedBranch), AttachEventsToLeftTree);
                            LoadRightTable();
                        }
                    }, 500);
                }
            }
        });

        //checkboxes
        $('input[id^="checkbox_"').change(function () {
            if (sendState === null) {
                itwascheck = true;
                sendState = $.ajax({
                    type: "POST",
                    url: '/ADSync/SaveSelected/?GUID=' + encodeURIComponent($(this).attr('guid')) + '&state=' + $(this).prop('checked'),
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            sendState = null;
                        }
                    }
                });
            }
        });

        if (selectedBranch !== null)
            $('tr[guid="' + selectedBranch + '"]').addClass('selected');
    }

    function EnableNext(enable) {
        $('.nextButton').prop('disabled', enable === false);
    }

    function ApplySelectedPlane() {
        $('#SQLPlaneID').val($('#SelectSQLPlaneID option:selected').text());
    }

    function ApplySelectedDepartment() {
        $('#SQLRootDepartment').val($('#tariscope-department tr.selected').find('td[data-name="Name"]').text());
    }

    function ApplySelectedPatches() {
        $.ajax({
            type: "POST",
            url: '/ADSync/GetPathes/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#directoryPathes').val(response.pathes);
                }
            }
        });
    }

    //show modal for connect to ad
    $('#connectoToLDAPShowmodal').on('click', () => { $('#connectToLDAPmodal').modal('show'); });

    //confirm connection to ad
    $('#connectToLDAPbtn').on('click', () => {
        $('#connectToLDAPmodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/ADSync/Connect/',
            data: $('#LDAPConnection').serialize(),
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    ShowConnectionMessage(response.success, response.message, response.url);
                }
            }
        });
    });

    //all next buttons
    $('.nextButton').on('click', function () {
        let to = $(this).data('to') * 1;

        $('#Step' + (to - 1)).hide();
        $('#Step' + to).show();

        EnableNext(false);

        if (to === 2)
        {
            LoadDepartments();
        }

        if (to === 3)            
            EnableNext(true);

        if (to === 4) {
            ApplySelectedPlane();
            ApplySelectedDepartment();
            ApplySelectedPatches();
        }
    });

    //all prev buttons
    $('.prevButton').on('click', function () {
        let to = $(this).data('to') * 1;

        $('#Step' + (to + 1)).hide();
        $('#Step' + to).show();

        EnableNext(true);
    });

    //fix right padding
    $('#Successdmodal, #Errordmodal, #connectToLDAPmodal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
    });

    //cancel button
    $('.cancelBtn').on('click', () => { window.location = "/ADSync"; });

    EnableNext(false);

});