﻿function createTD(dt, ht, hd, isTH = false) {
    //create cell
    var td = document.createElement(isTH ? 'th' : 'td');
    td.setAttribute('data-name', dt);
    td.innerText = ht;

    if (!hd)
        td.setAttribute('hidden', 'hidden');

    return td;
}

function GetAbonent(left, e, parent, hide = true, hd) {
    //create abonent row
    var tr = document.createElement('tr');
    tr.setAttribute('data-id', e.ID);
    tr.setAttribute('data-isdepartment', 'false');
    tr.setAttribute('data-departmentid', e.DepartmentID);
    tr.setAttribute('data-abonentid', e.ID);
    tr.setAttribute('data-parentID', parent);

    var span = document.createElement('span');
    span.innerHTML = e.Name;
    span.style.marginLeft = (left * 1 + 28) + 'px';

    var td = createTD('Name', "", true);
    td.appendChild(span);

    tr.appendChild(td);
    tr.appendChild(createTD('Number', e.NumberIP, hd[1]));
    tr.appendChild(createTD('Rate', e.PlaneName, hd[2]));
    tr.appendChild(createTD('NumberCount', e.DNsCount, hd[3]));
    tr.appendChild(createTD('ID', e.ID, hd[4]));
    tr.appendChild(createTD('Description', e.Description, hd[5]));
    tr.appendChild(createTD('Contract', e.Contract, hd[6]));
    tr.appendChild(createTD('Balance', e.Balance, hd[7]));
    tr.appendChild(createTD('Information', e.Information, hd[8]));
    tr.appendChild(createTD('AllNumbers', e.AllDNs, hd[9]));
    tr.appendChild(createTD('ContractDate', e.ContractDate, hd[10]));
    tr.appendChild(createTD('DateOn', e.DateOn, hd[11]));
    tr.appendChild(createTD('DateOff', e.DateOff, hd[12]));
    tr.appendChild(createTD('AccountID', e.AccountID, hd[13]));
    tr.appendChild(createTD('NumberDescription', e.DNDesciption, hd[14]));

    if (hide === true)
        tr.style.display = 'none';

    if (e.Balance < 0)
        tr.style.color = 'red';

    return tr;
}