﻿$(document).ready(() => {
    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerTo').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
    }

    function MakeDisable(num) {
        //disable nex steps if prev was proccesed again
        for (var i = num; i < 8; i++) {
            var elem = $('a[aria-controls="step' + (i + 2) + '"]');
            elem.parent().addClass('disabled');
        }
    }

    function nextTab(elem) {
        //go to next wizard page
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    function prevTab(elem) {
        //go to prev wizard page
        $(elem).prev().find('a[data-toggle="tab"]').click();
    }

    function LoadPlots() {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/AI/Groups/GetPlots',
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response.success) {
                    let c = `checked="checked"`;
                    for (key in response.plots) {
                        $('#myCarouselItems').append(
                            `<div class="col-xs-6 col-sm-4">
                                    <label for="r${key}">
                                        <input id="r${key}" type="radio" name="pKey" value="${key}" ${c}/>
                                        <span>
                                            <img src="data:image/svg+xml;utf8;base64,${response.plots[key]}" alt="Numbger of groups ${key}" data-groups="${key}" style="width: 90%"/>
                                        </span>
                                    </label>
                                </div>`);
                        c = '';
                    }
                }
                else {
                    $('#ErrorModal').modal('show');
                    $('#ErrorModalMsg').text($('#UnexpectedErrorMsg').val());
                }
            }
        });
    }

    function GetState() {
        $.ajax({
            type: "POST",
            async: true,
            url: '/AI/Groups/GroupingState',
            traditional: true,
            success: function (response) {
                if (response.IsCompleted) {
                    if (response.IsSuccess) {
                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);
                        MakeDisable(2);
                        LoadPlots();
                    }
                    else {
                        $('#ErrorModalMsg').text(response.Message);
                        $('#ErrorModal').modal('show');
                    }
                }
                else {
                    $('#procc').css("width", `${response.Percentage}%`);
                    $('#proccMsg').text(response.Message);

                    setTimeout(GetState, 500);
                }
            }
        });
    }

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //cloase wizard
    $('#CloseWizard, #CancelImport').on('click', function () {
        window.location = '/AI/Groups';
    });

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //send settings
    $('#SendSettingsButton').on('click', function () {
        ShowSpinner(true);

        var data = new FormData();
        data.append('groups', $('#MaxGroups').val());

        let from = $('#datetimepickerFrom').data('date');
        data.append('from', from == undefined ? $('#datetimepickerFromValue').val() : from);

        let to = $('#datetimepickerTo').data('date');
        data.append('to', to == undefined ? $('#datetimepickerToValue').val() : to);

        $.ajax({
            type: "POST",
            async: true,
            url: '/AI/Groups/BeginGroupAll',
            data: data,
            datatype: 'json',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                var $active = $('.wizard .nav-tabs li.active');
                $active.next().removeClass('disabled');
                nextTab($active);
                MakeDisable(2);
                ShowSpinner(false);
                GetState();
            }
        });
    });

    //confirm selected grpup
    $('#SaveSelectedGroup').on('click', function () {
        ShowSpinner(true);

        var data = new FormData();
        data.append('groups', $('input[name=pKey]:checked').val());

        let from = $('#datetimepickerFrom').data('date');
        data.append('from', from == undefined ? $('#datetimepickerFromValue').val() : from);

        let to = $('#datetimepickerTo').data('date');
        data.append('to', to == undefined ? $('#datetimepickerToValue').val() : to);

        $('#groupsS').text($('input[name=pKey]:checked').val());

        $.ajax({
            type: "POST",
            async: true,
            url: '/AI/Groups/SaveGrouping',
            data: data,
            datatype: 'json',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                var $active = $('.wizard .nav-tabs li.active');
                $active.next().removeClass('disabled');
                nextTab($active);
                MakeDisable(3);
                ShowSpinner(false);
            }
        });
    });

    initdatetime();
});